// MultiLangView.cpp
// 多言語表示ビューの実装

#include "MultiLangView.h"

static const int BUFFER_SIZE = 1024;
static const char LANGUAGE_MENU_FIELD[] = "MultiLanguageMenu";

// コンストラクタの引数はすべて基底クラスのBViewに任せる
TMultiLangView::TMultiLangView(BRect _rect,const char* _name,
					uint32 _resizing_mode,uint32 _flags)
	:BView(_rect,_name,_resizing_mode,_flags)
	 ,m_multi_lang_menu(new TMultiLangMenu(MULTI_LANG_MENU_NAME) )
{
	TMultiLang* lang = TMultiLang::GetMultiLang();
	lang->AddObserver(this);
}

// コンストラクタのアーカイブバージョン
TMultiLangView::TMultiLangView(BMessage* _archive)
	:BView(_archive)
{
	BMessage* archived_menu = new BMessage();
	_archive->FindMessage(LANGUAGE_MENU_FIELD,archived_menu);
	
	m_multi_lang_menu = 
			cast_as(instantiate_object(archived_menu),TMultiLangMenu);
	ASSERT(m_multi_lang_menu != NULL);

	TMultiLang* lang = TMultiLang::GetMultiLang();
	lang->AddObserver(this);
}

TMultiLangView::~TMultiLangView()
{
	RemoveMultiLangMenu();
	delete m_multi_lang_menu;
}

// 「言語」メニューを追加
bool TMultiLangView::AddMultiLangMenu()
{
	BMenuBar* menubar = getMultiLangMenuBar();

	if (menubar == NULL) return false;
	else	menubar->AddItem(m_multi_lang_menu);
	return true;
}

// 「言語」メニューを取り除く
bool TMultiLangView::RemoveMultiLangMenu()
{
	BMenuBar* menubar = getMultiLangMenuBar();
	
	if (menubar == NULL) return false;
	else	
	{
#ifdef DEBUG
		ASSERT(menubar->RemoveItem(m_multi_lang_menu) == true);
#else
		menubar->RemoveItem(m_multi_lang_menu);
#endif		
	}
	return true;
}

// メニューバーの作成
BMenuBar* TMultiLangView::CreateMultiLangMenuBar
				(BRect _frame,
				 uint32 _resizingMode = B_FOLLOW_LEFT_RIGHT |
				 				    B_FOLLOW_TOP,
				 menu_layout _layout = B_ITEMS_IN_ROW,
				 bool _resizeToFit = true)
{
	BMenuBar* temp = new BMenuBar(_frame,MULTI_LANG_MENUBAR_NAME,
						_resizingMode,
						_layout,_resizeToFit);
	AddChild(temp);
	return temp;
}

// メニューバーからアイテムをすべて取り除く
bool TMultiLangView::CleanupMenuBar()
{
	BMenuBar* menubar = getMultiLangMenuBar();
	if (menubar == NULL) return false;

	RemoveMultiLangMenu();
	

	int32 num_of_menu;
	num_of_menu = menubar->CountItems();
		
	while (num_of_menu-- > 0)
	{
		BMenu* remove_menu;
		remove_menu = menubar->SubmenuAt(0);
		if(remove_menu != NULL)
		{
			menubar->RemoveItem(remove_menu);
			delete remove_menu;
		}
	}

	return true;
}

// 言語が変更されたときなにもしない
void TMultiLangView::LangChanged(const char* _lang)
{
}

// メニューバーの取得
BMenuBar* TMultiLangView::getMultiLangMenuBar()
{
	return dynamic_cast<BMenuBar*>(FindView(MULTI_LANG_MENUBAR_NAME));
}


BArchivable* TMultiLangView::Instantiate(BMessage* _archive)
{
	if(validate_instantiation(_archive,"TMultiLangView"))
	{
		return new TMultiLangView(_archive);
	}
	
	return NULL;
}

// アーカイブ化
status_t TMultiLangView::Archive(BMessage* o_archive,bool _deep) const
{
	status_t ret;
	ret = BView::Archive(o_archive,_deep);
	if (ret != B_OK) return ret;
	
	o_archive->AddString("class",class_name(this));


	if (_deep)
	{
		BMessage* archived_menu = new BMessage();
		ret = m_multi_lang_menu->Archive(archived_menu,_deep);
		if (ret == B_OK)
		{
			o_archive->AddMessage(LANGUAGE_MENU_FIELD,
								archived_menu);
		}
		else
		{
			return ret;
		}

	}
	return B_OK;
}



