// WaitWindow.h
// 待ち受けウィンドウクラスの作成

#ifndef WAIT_WINDOW_H_
#define WAIT_WINDOW_H_

#include <Rect.h>
#include <Point.h>
#include <Window.h>
#include <StringView.h>
#include <OS.h>

#include <memory>
#include <string>

using std::auto_ptr;
using std::string;

class TWaitWindow
{
public:
	TWaitWindow(BRect _rect,const char* _title,const char* _show_string);

	// 左上のポイントだけの指定。大きさは文字列に合わせて自動的に決定される
	TWaitWindow(BPoint _left_top,const char* _title,const char* _show_string);

	bool Begin();  // ウィンドウを表示し始める
	void End();    // ウィンドウを消去する
private:
	~TWaitWindow() {}

	// コンストラクタのヘルパ関数
	void init(BRect _rect,const char* _title,const char* _show_string);

	BStringView* m_string;    // 表示するメッセージ
	BWindow* m_win; 		// ウィンドウ
	BRect m_rect;			 // ウィンドウの矩形
	string m_title;           // ウィンドウのタイトル
};

#endif // WAIT_WINDOW_H_