#ifndef ABOUT_WINDOW_H_
#define ABOUT_WINDOW_H_

#include <Application.h>
#include <Roster.h>
#include <AppFileInfo.h>
#include <Window.h>
#include <View.h>
#include <Point.h>
#include <StringView.h>
#include <Button.h>
#include <Font.h>
#include <Bitmap.h>
#include <Screen.h>
#include <Debug.h>
#include <OS.h>

#include <string>

#include <cstdlib>

using std::string;

class TAboutView : public BView
{
public:
	TAboutView(BRect& _rect,	const char* _app_name,
						const char* _copyright,
						const char* _version,
						const char* _url);
	~TAboutView();
		
	virtual void AttachedToWindow();
	virtual void Draw(BRect _update_rect);
	virtual void MessageReceived(BMessage* _msg);
private:
	BBitmap* getLargeIcon();

	BBitmap* m_large_icon;
	BButton* m_ok_button;
	BButton* m_webpage_button;
	BStringView* m_app_name_string;
	BStringView* m_copyright_string;
	BStringView* m_version_string;
	string m_url;
};

class __TAboutWindow : public BWindow
{
public:
	__TAboutWindow(BRect _rect,const char* _title,
						const char* _app_name,
						const char* _copyright,
						const char* _version,
						const char* _url);
	~__TAboutWindow() {}
	virtual bool QuitRequested();

private:
	TAboutView* m_view;
};

class TAboutWindow
{
public:
	TAboutWindow(BRect _left_top,
				const char* _title,
				const char* _app_name,
				const char* _version,
				const char* _copyright,
				const char* _url = "");
		
	~TAboutWindow();

	void Hide() { m_win->Hide(); }
	void Show();
private:
	__TAboutWindow* m_win;
	TAboutView* m_view;
	bool m_shown_flag; // 一回でも表示されたかどうかのフラグ
};

#endif // ABOUT_WINDOW_H_