#include "CClockDeskbarView.h"

/*************************
 * コンストラクタ
 * 
 * 引数
 * _messenger:クリックされたらメッセージを送る先
 * _name:ビューの名前
 * _icon:ビューに表示するビットマップ,NULLだとアプリケーションアイコンが使われる
 */
TCClockDeskbarView::TCClockDeskbarView(BMessenger _messenger,
				const char* _name,BBitmap* _icon = NULL)
	:BView(BRect(0,0,15,15),_name,B_FOLLOW_ALL_SIDES,B_WILL_DRAW),
	 m_messenger(_messenger),
	 m_icon(_icon)
{
	if(m_icon == NULL) m_icon = getAppIcon();
	else              ResizeTo(_icon->Bounds().Width(),
							_icon->Bounds().Height());

	SetDrawingMode(B_OP_OVER);
}

// アーカイブの復元
TCClockDeskbarView::TCClockDeskbarView(BMessage* _archive)
	:BView(_archive)
{
	BMessage* msg = new BMessage();
	_archive->FindMessage(ICON_FIELD,msg);
	m_icon = cast_as(instantiate_object(msg),BBitmap);
	
	_archive->FindMessenger(MESSENGER_FIELD,&m_messenger);
}

TCClockDeskbarView::~TCClockDeskbarView()
{
	delete m_icon;
}

void TCClockDeskbarView::AttachedToWindow()
{
	if(Parent())
	{
		SetViewColor(Parent()->ViewColor());
	}
}

// アーカイブ化
status_t TCClockDeskbarView::Archive(BMessage* o_archive,bool _deep = true) const
{
	status_t ret;
	ret = BView::Archive(o_archive,_deep);
	if (ret != B_OK) return ret;

//	o_archive->AddString("class","TCClockDeskbarView");

	o_archive->AddString("add_on",CCLOCK_SIGNATURE);

	ret = o_archive->AddMessenger(MESSENGER_FIELD,m_messenger);
	ASSERT(ret == B_OK);
	
	if (_deep)
	{
		BMessage* add_message = new BMessage();
		ret = m_icon->Archive(add_message,_deep);
		if (ret == B_OK)
		{
			o_archive->AddMessage(ICON_FIELD,add_message);
		}
		else
		{
			return B_ERROR;
		}
	}
	return B_OK;
}

/*
void TCClockDeskbarView::MessageReceived(BMessage* _msg)
{
	BPoint point;
	status_t ret;

	switch(_msg->what)
	{
	case B_MOUSE_DOWN:

		_msg->ReplacePoint("where", ConvertToScreen(_msg->FindPoint("where")));
		m_messenger.SendMessage(_msg);

		ret = _msg->FindPoint("where",&point);
		ASSERT(ret == B_OK);

		ConvertToScreen(&point);
#ifdef DEBUG
		point.PrintToStream();
#endif
	
		ret = _msg->ReplacePoint("where",point);
		ASSERT(ret == B_OK);
		
		m_messenger.SendMessage(_msg);	

		break;
	default:
		ret = _msg->FindPoint("where",&point);
		if (ret == B_OK)
		{
			ConvertToScreen(&point);
			ret = _msg->ReplacePoint("where",point);
			ASSERT(ret == B_OK);
			m_messenger.SendMessage(_msg);	
		}		
		else BView::MessageReceived(_msg);
		break;
	}
}
*/

void TCClockDeskbarView::Draw(BRect _update_rect)
{
	DrawBitmap(m_icon);
}

void TCClockDeskbarView::MouseDown(BPoint _point)
{
	BMessage* msg = Looper()->CurrentMessage();

#ifdef DEBUG
	_point.PrintToStream();
#endif

	ConvertToScreen(&_point);

#ifdef DEBUG
	_point.PrintToStream();
#endif

	msg->ReplacePoint("where",_point);
	m_messenger.SendMessage(msg);	
}


BArchivable* TCClockDeskbarView::Instantiate(BMessage* _archive)
{
	if (validate_instantiation(_archive,"TCClockDeskbarView"))
	{
		return new TCClockDeskbarView(_archive);
	}
	
	return NULL;
}


BBitmap* TCClockDeskbarView::getAppIcon()
{
	ASSERT_WITH_MESSAGE(be_app != NULL,"BApplication not initialized!");

	status_t ret;
	app_info info;

	ret = be_app->GetAppInfo(&info);
	ASSERT_WITH_MESSAGE(ret == B_OK,"GetAppInfo Failed!");
		
	BBitmap* icon = new BBitmap(BRect(0,0,15,15),B_CMAP8);
	
	BFile file(&info.ref,B_READ_WRITE);
	BAppFileInfo app_file_info(&file);
	
	ret = app_file_info.GetIcon(icon,B_MINI_ICON);
	ASSERT (ret == B_OK);
	return icon;
}
