#include "CClockView.h"

#define MAIN_OK_BUTTON_RECT    BRect(_rect.right-80,_rect.bottom-30,_rect.right-10,_rect.bottom-10)
#define PERMANENT_BUTTON_RECT  BRect(_rect.right-160,_rect.bottom-30,_rect.right-90,_rect.bottom-10)
#define SERVER_NAME_CONTROL_RECT BRect(10,10+MAIN_MENU_HEIGHT,_rect.right-10,30+MAIN_MENU_HEIGHT)
#define PERMANENT_CHECKBOX_RECT BRect(10,40+MAIN_MENU_HEIGHT,100,60+MAIN_MENU_HEIGHT)
#define PULSE_TEXT_CONTROL_RECT BRect(110,40+MAIN_MENU_HEIGHT,270,60+MAIN_MENU_HEIGHT)

// TIMEOUT_TEXTは文字列の長さでテキスト部の長さを変えているので
// コンストラクタ内のコードに注意
#define TIMEOUT_TEXT_CONTROL_RECT BRect(10,70+MAIN_MENU_HEIGHT,160,90+MAIN_MENU_HEIGHT)



// const BRect& PERMANENT_BUTTON_RECT = BRect(210,70,260,90);
const float MAIN_MENU_HEIGHT = 20.0f;

TCClockView::TCClockView(BRect _rect,const char* _name)
	:TMultiLangView(_rect,_name,MAIN_VIEW_RESIZING_MODE,MAIN_VIEW_FLAGS)
{
	TConfigFile* config_file;
	config_file = TConfigFile::GetConfigFile(CONFIG_FILENAME);

	TMultiLang* lang = TMultiLang::GetMultiLang();

	SetViewColor(200,200,200);

	// Create Enter ServerPath Text サーバーパスを入力する場所
	m_server_name_text = new BTextControl(SERVER_NAME_CONTROL_RECT,
									SERVER_TEXT_CONTROL_NAME,
									lang->GetString(SERVER_TEXT_CONTROL_LABEL),
									config_file->GetValue(CONFIG_SERVERNAME).c_str(),
									new BMessage(SERVER_NAME_TEXT_MODIFIED));
	m_server_name_text->SetDivider(BFont(be_plain_font).StringWidth(SERVER_TEXT_CONTROL_LABEL));

	// Create OK Button OKボタン
//	m_ok_button = new BButton(BRect(_rect.right-80,_rect.bottom-30,_rect.right-10,_rect.bottom-10),
	m_ok_button = new BButton(MAIN_OK_BUTTON_RECT,
							MAIN_OK_BUTTON_NAME,
							lang->GetString(MAIN_OK_BUTTON_LABEL),
							new BMessage(MAIN_OK_BUTTON_CLICKED));

	// Create Permanent Button (常駐ボタン)
	m_permanent_button = new BButton(PERMANENT_BUTTON_RECT,
								PERMANENT_BUTTON_NAME,
								lang->GetString(PERMANENT_BUTTON_LABEL),
								new BMessage(PERMANENT_BUTTON_CLICKED));
	m_permanent_button->SetEnabled(false);

	// 常駐チェックボックス
	m_permanent_checkbox = new BCheckBox(PERMANENT_CHECKBOX_RECT,
									PERMANENT_CHECKBOX_NAME,
									lang->GetString(PERMANENT_CHECKBOX_LABEL),
									new BMessage(PERMANENT_CHECKBOX_CLICKED));

	
	// 更新間隔テキストボックス
	m_pulse_rate_text = new BTextControl(PULSE_TEXT_CONTROL_RECT,
								   PULSE_TEXT_CONTROL_NAME,
								   lang->GetString(PULSE_TEXT_CONTROL_LABEL),
								   config_file->GetValue(CONFIG_PULSE_RATE).c_str(),
								   new BMessage(PULSE_TEXT_MODIFIED));
	m_pulse_rate_text->SetDivider(BFont(be_plain_font).StringWidth(lang->GetString(PULSE_TEXT_CONTROL_LABEL)));
	m_pulse_rate_text->SetEnabled(false);
	allowOnlyNum(m_pulse_rate_text->TextView());
	if(!config_file->IsExistKey(CONFIG_PULSE_RATE) ) // 初回の起動だったらデフォルト値を適用 
	{
		ostrstream ost;
		ost << (DEFAULT_PULSE_RATE / PULSE_RATE_TIMES) << '\0';
		m_pulse_rate_text->SetText(ost.str());
	}

	m_timeout_text = new BTextControl(TIMEOUT_TEXT_CONTROL_RECT,
								TIMEOUT_TEXT_CONTROL_NAME,
								lang->GetString(TIMEOUT_TEXT_CONTROL_LABEL),
								config_file->GetValue(CONFIG_TIMEOUT).c_str(),
								new BMessage(TIMEOUT_TEXT_MODIFIED));

	m_timeout_text->SetDivider(BFont(be_plain_font).StringWidth(lang->GetString(TIMEOUT_TEXT_CONTROL_LABEL)));
	allowOnlyNum(m_timeout_text->TextView());
	if(!config_file->IsExistKey(CONFIG_TIMEOUT) ) // 初回の起動だったらデフォルト値を適用
	{
		ostrstream ost;
		ost << (DEFAULT_TIMEOUT / TIMEOUT_TIMES) << '\0';
		m_timeout_text->SetText(ost.str());
	}


	AddChild(m_server_name_text);
	AddChild(m_ok_button);
	AddChild(m_permanent_checkbox);
	AddChild(m_pulse_rate_text);
	AddChild(m_timeout_text);
}

/**********************************************
 *  デストラクタ
 *  
 */

TCClockView::~TCClockView()
{
}

/**********************************************
 *  AttatchedToWindow関数
 *   ボタンなどのメッセージのターゲット変更
 */
void TCClockView::AttachedToWindow()
{
	TConfigFile* config_file;
	config_file = TConfigFile::GetConfigFile(CONFIG_FILENAME);

	initMenu(Bounds());

	m_ok_button->SetTarget(this);
	m_ok_button->MakeDefault(this);

	m_server_name_text->SetTarget(this);
	m_server_name_text->MakeFocus(true);
	
	m_permanent_checkbox->SetTarget(this);
	m_permanent_button->SetTarget(this);
	m_pulse_rate_text->SetTarget(this);
	m_timeout_text->SetTarget(this);

	bool permanent_flag;
	if (config_file->GetBool(CONFIG_IS_PERMANENT,&permanent_flag) == TConfigFile::OK &&
		permanent_flag == true)
	{
		m_permanent_checkbox->SetValue(B_CONTROL_ON);
	}
	else
	{
		m_permanent_checkbox->SetValue(B_CONTROL_OFF);
	}
	
	setEnabledByPermanent();

}

/**********************************************
 *  LangChanged関数
 *  言語変更の処理
*/
void TCClockView::LangChanged(const char* _lang)
{
	updateTextLabel();
}


/**********************************************
 *  initMenu関数
 *  メニュー初期化
 */
void TCClockView::initMenu(const BRect& _rect)
{
	
	if (m_menubar != NULL)
	{
		CleanupMenuBar();	
	}
	else
	{
		m_menubar = CreateMultiLangMenuBar(BRect(0,0,_rect.Width(),MAIN_MENU_HEIGHT));
	}

	TMultiLang* lang = TMultiLang::GetMultiLang();

	BMenu* p_menu;
	BMenuItem* p_menu_item;

	// ファイルメニューの調整
	p_menu = new BMenu(lang->GetString(MAIN_MENU_FILE_CAPTION) );

	p_menu_item = new BMenuItem(lang->GetString(MAIN_MENU_QUIT_CAPTION),new BMessage(B_QUIT_REQUESTED),'Q');
	p_menu_item->SetTarget(be_app);
	p_menu->AddItem(p_menu_item);

	m_menubar->AddItem(p_menu);

	// ヘルプメニューの調整
	p_menu = new BMenu(lang->GetString(MAIN_MENU_HELP_CAPTION) );

	p_menu_item = new BMenuItem(lang->GetString(MAIN_MENU_ABOUT_CAPTION)
							,new BMessage(B_ABOUT_REQUESTED));
	p_menu_item->SetTarget(be_app);
	p_menu->AddItem(p_menu_item);

	m_menubar->AddItem(p_menu);

	AddMultiLangMenu();
}

/**********************************************
 *  MessageReceived関数
 */
 
void TCClockView::MessageReceived(BMessage* _msg)
{
	// 自分自身のウィンドウの取得
	TCClockWindow* win = dynamic_cast<TCClockWindow*>(Window()); 
	ASSERT(win != NULL);

	switch(_msg->what)
	{
	case SERVER_NAME_TEXT_MODIFIED:
		break;
	case MAIN_OK_BUTTON_CLICKED:
		switch (m_permanent_checkbox->Value())
		{
		case B_CONTROL_ON:
			win->SetParmanent(true,atoi(m_pulse_rate_text->Text()) * PULSE_RATE_TIMES);
			win->Hide();
			break;
		case B_CONTROL_OFF:
			_msg->AddString(SERVER_NAME_FIELD,m_server_name_text->Text());
			win->SetTimeout(atoi(m_timeout_text->Text() )*TIMEOUT_TIMES);
			win->PostMessage(_msg);
			break;
		}
		break;
	case PERMANENT_CHECKBOX_CLICKED:
		setEnabledByPermanent();
		break;
	case TIMEOUT_TEXT_MODIFIED:   // タイムアウトの設定
		win->SetTimeout(atoi(m_timeout_text->Text() )*TIMEOUT_TIMES);
#ifdef DEBUG
		cout << "TIMEOUT_TEXT_MODIFIED" << endl;
#endif
		break;	
	case PULSE_TEXT_MODIFIED:      // 更新間隔テキスト
		win->SetParmanent(true,atoi(m_pulse_rate_text->Text() )*PULSE_RATE_TIMES );
#ifdef DEBUG
		cout << "PULSE_TEXT_MODIFIED" << endl;
		cout << "PULSE_RATE: " << atoi(m_pulse_rate_text->Text() )*PULSE_RATE_TIMES << endl;
#endif
		break;
	default:
		BView::MessageReceived(_msg);
		break;
	}
}

/**********************************************
 *  Pulse関数
 *  常駐時の処理
 */
void TCClockView::Pulse()
{
	TCClockWindow* win = dynamic_cast<TCClockWindow*>(Window());
	ASSERT(win != NULL);
	win->Pulse();
}

// テキストコントロールを数字しか入力出来ないようにする
void TCClockView::allowOnlyNum(BTextView* _text_view)
{
	for(int i=0;i<256;i++)
	{
		if(isdigit(i))
		{
			_text_view->AllowChar(i);
		}
		else
		{
			_text_view->DisallowChar(i);
		}
	}
}

// 常駐チェックボックスによって、
// コントロールのEnabledを操作する関数
void TCClockView::setEnabledByPermanent()
{
	TMultiLang* lang = TMultiLang::GetMultiLang();

	// 自分自身のウィンドウの取得
	TCClockWindow* win = dynamic_cast<TCClockWindow*>(Window()); 
	ASSERT(win != NULL);
	
	switch (m_permanent_checkbox->Value())
	{
	case B_CONTROL_ON: // 常駐ボタンなどをenableに
		m_permanent_button->SetEnabled(true);
		m_pulse_rate_text->SetEnabled(true);
		win->SetParmanent(true,atoi(m_pulse_rate_text->Text() )*1000000 );
		m_ok_button->SetLabel(lang->GetString(PERMANENT_BUTTON_LABEL));

		break;			

	case B_CONTROL_OFF:
		m_permanent_button->SetEnabled(false);
		m_pulse_rate_text->SetEnabled(false);
		win->SetParmanent(false,0);
		m_ok_button->SetLabel(lang->GetString(MAIN_OK_BUTTON_LABEL));

		break;
	}	

}

// テキスト更新
void TCClockView::updateTextLabel()
{
	TMultiLang* lang = TMultiLang::GetMultiLang();

	Looper()->Lock();
	m_server_name_text->SetLabel(lang->GetString(SERVER_TEXT_CONTROL_NAME) );
	m_ok_button->SetLabel(lang->GetString(MAIN_OK_BUTTON_LABEL));
	m_permanent_button->SetLabel(lang->GetString(PERMANENT_BUTTON_LABEL));
	m_permanent_checkbox->SetLabel(lang->GetString(PERMANENT_CHECKBOX_LABEL));
	m_pulse_rate_text->SetLabel(lang->GetString(PULSE_TEXT_CONTROL_LABEL));

	m_pulse_rate_text->SetDivider(BFont(be_plain_font).StringWidth
								(lang->GetString(PULSE_TEXT_CONTROL_LABEL) ));
	m_timeout_text->SetLabel(lang->GetString(TIMEOUT_TEXT_CONTROL_LABEL));

	m_timeout_text->SetDivider(BFont(be_plain_font).StringWidth(lang->GetString(TIMEOUT_TEXT_CONTROL_LABEL)));

	initMenu(Bounds());
	setEnabledByPermanent();
	Looper()->Unlock();

}