// CClockWindow.h

#ifndef CCLOCK_WINDOW_H_
#define CCLOCK_WINDOW_H_

#include <Application.h>
#include <String.h>

#include "MainWindow.h"
#include "WaitWindow.h"
#include "CClockView.h"
#include "CClockDefs.h"
#include "ConfigFile.h"
#include "CorrectTimeGetter.h"

#include <memory>
#include <strstream>

using std::ostrstream;
using std::auto_ptr;

class TCClockWindow : public TMainWindow
{
public:
	TCClockWindow(BRect _rect,const char* _title);
	~TCClockWindow();
	virtual bool QuitRequested();
	virtual void MessageReceived(BMessage* _msg);

	void SetParmanent(bool _flag,bigtime_t _pulse_rate = DEFAULT_PULSE_RATE);
	bool GetParmanent() { return m_parmanent_flag; } // 常駐状態か？

	void SetTimeout(bigtime_t _timeout) { m_timeout = _timeout; }
	void Pulse();	// 常駐時に定期的に呼ばれる関数

private:
	
	void saveSettings();
	void timeGetting(const char* _server_name);
	void ntpPacketAnalyze(NtpPacket* _packet,LocalTimeInfo* _local_time);
	
	void ShowMessage(const char* _kind,const char* _message);
	
	TCorrectTimeGetter* m_time_getter;	
	TCClockView* m_view;
	TWaitWindow* m_wait_window;

	string m_last_connected_server; // 最後に接続したサーバー名

	bool m_parmanent_flag;		// 接続
	bigtime_t m_pulse_rate;      // 更新間隔
	bigtime_t m_timeout;         // タイムアウト時間
};

#endif // CCLOCK_WINDOW_H_

