// ConfigFile.h
// 設定を保存するファイルのアクセスクラス

#ifndef CONFIG_FILE_H_
#define CONFIG_FILE_H_

#include <fstream>
#include <string>
#include <vector> 
#include <map>
#include <memory> // auto_ptr
#include <algorithm>
#include <strstream>
#include <cstdio>

#ifdef B_BEOS_VERSION
#include <Application.h>
#include <Entry.h>
#include <Directory.h>
#include <Path.h>
#include <FindDirectory.h>
#include <Debug.h>
#endif

using std::map;
using std::string;
using std::auto_ptr;
using std::ostrstream;

class TConfigFile;

typedef map<string,TConfigFile*> CONFIGFILES_MAP;
typedef map<string,string>       CONFIGFILE_DATABASE;
typedef pair<string,string>      CONFIGFILE_DATABASE_PAIR;

class TConfigFile 
{
public:
	bool Save();
	bool Load();
	
	void SetValue(const char* _key,const char* _value) 
		{ (*m_config_info)[_key] = _value; }

	// キーから値を取得する関数
	string GetValue(const char* _key)
		{ if (IsExistKey(_key)) return (*m_config_info)[_key]; 
		  else                   return ""; } 
	
	void SetValue(const char* _key,bool _value);
	void SetValue(const char* _key,int32 _value);
	void SetValue(const char* _key,int64 _value);
	
	enum { NOT_KEY_EXIST,ERROR = 0,OK};

	// 戻り値はエラーコード
	int GetBool(const char* _key,bool* o_value);
	int GetInt32(const char* _key,int32* o_value);
	int GetInt64(const char* _key,int64* o_value);

	bool IsExists();	// ファイルが存在するかどうかを返す
	bool IsExistKey(const char* _key)
		{ return (m_config_info->find(_key) != m_config_info->end()) ? true : false ; }

	
	static TConfigFile* GetConfigFile(const char* _filename);

protected:
	TConfigFile();
	TConfigFile(TConfigFile&);
	TConfigFile(const char* _filename);
	TConfigFile& operator=(TConfigFile&);
	virtual ~TConfigFile();

	bool setFilename(const char* _filename);

	bool createDirectory(const char* _path,mode_t _mode = 0755);
	void writeKeys(ofstream& _stream);

#ifdef B_BEOS_VERSION
	string getSettingFolderName();
#endif
private:
	string m_filename;
	CONFIGFILE_DATABASE* m_config_info;

	static CONFIGFILES_MAP& getOpenedFileMap();
};

#endif // CONFIG_FILE_H_