// MultiLangView.h
// 多言語ビューの設計

#ifndef MULTI_LANG_VIEW_H_
#define MULTI_LANG_VIEW_H_

#include <View.h>
#include <Menu.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <String.h>
#include <Debug.h>
#include <ClassInfo.h>
#include "MultiLang.h"
#include "MultiLangMenu.h"

#include <string>

static const char MULTI_LANG_MENUBAR_NAME[] = "MultiLangMenuBar";

class TMultiLangView : public BView,TMultiLangObserver
{
public:
	TMultiLangView(BRect _rect,const char* _name,
					uint32 _resizing_mode,uint32 _flags);
	TMultiLangView(BMessage* _archive);
	virtual ~TMultiLangView();

	static BArchivable* Instantiate(BMessage* _message);
	status_t Archive(BMessage* o_archive,
								bool _deep = true) const;

	virtual void LangChanged(const char* _lang);

	BMenu* GetMultiLangMenu() { return m_multi_lang_menu; }

	BMenuBar*  CreateMultiLangMenuBar
				(BRect _frame,
				 uint32 _resizingMode = B_FOLLOW_LEFT_RIGHT |
				 				    B_FOLLOW_TOP,
				 menu_layout _layout = B_ITEMS_IN_ROW,
				 bool _resizeToFit = true);
	bool CleanupMenuBar();
	
	virtual bool AddMultiLangMenu();
	virtual bool RemoveMultiLangMenu();
private:
	BMenuBar* getMultiLangMenuBar();

	TMultiLangMenu* m_multi_lang_menu;
};

#endif // MULTI_LANG_VIEW_H_
