/*
 * Copyright (c) 1999, Jesper Hansen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither name of the company nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//-----------------------------------------------------------------------------
#include <stdio.h>
//-------------------------------------
#include <interface/Alert.h>
#include <support/Beep.h>
//-------------------------------------
#include "misc/Settings.h"

#include "CAApp.h"
#include "CAWin.h"
//-----------------------------------------------------------------------------

damn::Settings *CAApp::fSettings = NULL;

//-----------------------------------------------------------------------------

CAApp::CAApp() :
	BApplication( APP_MIME )
{
	fWindow = NULL;
	fSettings = NULL;
}

CAApp::~CAApp()
{
	delete fSettings;
}

bool CAApp::QuitRequested()
{
	if( fWindow && (fWindow->Lock()) )
	{
		fWindow->Quit();
		fWindow = NULL;
	}

	return true;
}

void CAApp::AboutRequested()
{
	BAlert *alert = new BAlert( "",
		"CoffeeAlarm (c) Jesper Hansen",
		"Wheee", NULL, NULL, B_WIDTH_AS_USUAL, B_INFO_ALERT );
	alert->Go();
}

//-----------------------------------------------------------------------------

void CAApp::ArgvReceived( int32 argc, char **argv )
{
	if( argc >= 2 )
		fSetingsName = argv[1];
}

void CAApp::ReadyToRun()
{
	add_system_beep_event( "Coffee Alarm", 0 );

	BString wintitle = "Coffee Alarm";
	BString configfile = "CoffeeAlarm";
	if( fSetingsName != "" )
	{
		wintitle << " - " << fSetingsName;
		configfile << "-" << fSetingsName;
	}

	fSettings = new damn::Settings( configfile.String(), true );
	fWindow = new CAWin( wintitle.String() );
}

void CAApp::MessageReceived( BMessage *msg )
{
	switch( msg->what )
	{
		default:
//			msg->PrintToStream();
			BApplication::MessageReceived( msg );
	}
}

//-----------------------------------------------------------------------------
