/*
 * Copyright (c) 1999, Jesper Hansen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither name of the company nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//-----------------------------------------------------------------------------
//-------------------------------------
#include <app/Application.h>
#include <interface/MenuItem.h>
#include <interface/PopUpMenu.h>
//-------------------------------------
#include "dle/Split.h"
#include "dle/BBox.h"
#include "dle/BButton.h"
#include "dle/BCheckBox.h"
#include "dle/BMenuBar.h"
#include "dle/BMenuField.h"
//#include "dle/BSlider.h"
#include "dle/BStringView.h"
#include "dle/BTextControl.h"
#include "dle/Frame.h"
#include "dle/Line.h"
#include "dle/ProgressBar.h"
#include "dle/Space.h"
#include "misc/Settings.h"
//-------------------------------------
#include "CAWin.h"
#include "CAApp.h"
#include "LoadView.h"
#include "MiniSlider.h"
//-----------------------------------------------------------------------------

dle::Object *CAWin::FullScreenGui()
{
	fFullscreenBitmapView = new SelectionBitmapView( true );
	return fFullscreenBitmapView;
}

//-----------------------------------------------------------------------------

dle::Object *CAWin::NormalGui()
{
	dle::VSplit *vs = new dle::VSplit();
//	vs->SetInner( 8 );
	{
		// Menu
		vs->AddObject( GuiMenu(), 1.0f );
		
		// URL
		dle::Object *address = GuiAddress();
		address->SetInnerBottom( 0 );
		vs->AddObject( address, 1.0f );
		
		// Main
		dle::Object *main = GuiMain();
//		main->SetInnerTop( 0 );
		vs->AddObject( main, 1.0f );

		// Statusbar
		vs->AddObject( GuiStatusBar(), 1.0f );
	}
	return vs;
}

//-----------------------------------------------------------------------------

dle::Object *CAWin::GuiMenu()
{
	BMenu *menu;
	BMenuItem *item;

	dle::BMenuBar *menubar = new dle::BMenuBar( "", B_ITEMS_IN_ROW );
	menubar->InnerSpacing( false );
	{
		menu = new BMenu( "File" );
		{
			item = new BMenuItem( "Settings" B_UTF8_ELLIPSIS, new BMessage(MSG_SETTINGS), 'S' );
			menu->AddItem( item );

			menu->AddSeparatorItem();
				
			item = new BMenuItem( "About CoffeeAlarm" B_UTF8_ELLIPSIS, new BMessage(B_ABOUT_REQUESTED) );
			item->SetTarget( NULL, be_app );
			menu->AddItem( item );

			menu->AddSeparatorItem();
				
			item = new BMenuItem( "Quit", new BMessage(B_QUIT_REQUESTED), 'Q' );
			menu->AddItem( item );
		}
		menubar->AddItem( menu );

		fHistoryMenu = new BMenu( "History" );
		menubar->AddItem( fHistoryMenu );

		menu = new BMenu( "Window" );
		{
			item = new BMenuItem( "Zoom", new BMessage(MSG_ZOOM), 'Z' );
			menu->AddItem( item );

			item = new BMenuItem( "Fullscreen", new BMessage(MSG_FULLSCREEN), 'F' );
			menu->AddItem( item );
		}
		menubar->AddItem( menu );
	}
	return menubar;
}

dle::Object *CAWin::GuiAddress()
{
	dle::HSplit *hs = new dle::HSplit();
//	hs->SetInner( 2 );
	{
		fURLTextControl = new dle::BTextControl( CAApp::Settings()->GetString(CFG_URL), new BMessage(MSG_NEW_URL) );
		hs->AddObject( fURLTextControl, 1.0f );

		dle::BStringView *sv = new dle::BStringView( "Refresh:" );
		hs->AddObject( sv, 1.0f );

		BPopUpMenu *popmenu = new BPopUpMenu( "crap" );
		popmenu->AddItem( new BMenuItem("no delay", new BMessage(MSG_UPDATE0S)) );
		popmenu->AddItem( new BMenuItem("1/2 second", new BMessage(MSG_UPDATE05S)) );
		popmenu->AddItem( new BMenuItem("1 second", new BMessage(MSG_UPDATE1S)) );
		popmenu->AddItem( new BMenuItem("5 seconds", new BMessage(MSG_UPDATE5S)) );
		popmenu->AddItem( new BMenuItem("10 seconds", new BMessage(MSG_UPDATE10S)) );
		popmenu->AddItem( new BMenuItem("15 seconds", new BMessage(MSG_UPDATE15S)) );
		popmenu->AddItem( new BMenuItem("30 seconds", new BMessage(MSG_UPDATE30S)) );
		popmenu->AddItem( new BMenuItem("1 minute", new BMessage(MSG_UPDATE1M)) );
		popmenu->AddItem( new BMenuItem("5 minute", new BMessage(MSG_UPDATE5M)) );
		popmenu->AddItem( new BMenuItem("10 minute", new BMessage(MSG_UPDATE10M)) );
		popmenu->AddItem( new BMenuItem("15 minute", new BMessage(MSG_UPDATE15M)) );
		dle::BMenuField *menu = new dle::BMenuField( popmenu );
		menu->Menu()->Superitem()->SetLabel( menu->Menu()->ItemAt(0)->Label() );

		// select the current one:
		int curmsg;
		if( fUpdateTimeMap.GetNearestEnum(CAApp::Settings()->GetInt64(CFG_UPDATETIME),&curmsg) == B_OK )
		{
//					for( int i=popmenu->CountItems()-1; i>=0; i-- )
			for( int i=10-1; i>=0; i-- )
			{
				BMenuItem *item = popmenu->ItemAt(i);
				if( item->Message()->what == (uint32)curmsg )
				{
					menu->Menu()->Superitem()->SetLabel( menu->Menu()->ItemAt(i)->Label() );
					break;
				}
			}
		}

		hs->AddObject( menu, 1.0f );
	}
	return hs;
}

dle::Object *CAWin::GuiMain()
{
	dle::BBox *box = NULL;
	
	dle::HSplit *hs = new dle::HSplit();
	{
		dle::Frame *frame = new dle::Frame( dle::Frame::FANCY_LOWERED );
		{
			fBitmapView = new SelectionBitmapView( true );
			fBitmapView->ForceWidth( fBitmapWidth );
			fBitmapView->ForceHeight( fBitmapHeight );
			frame->AddObject( fBitmapView, 1.0f );
		}
		hs->AddObject( frame, 1.0f );

		dle::VSplit *vs = new dle::VSplit();
		{
			dle::Frame *frame = new dle::Frame( dle::Frame::FANCY_LOWERED );
			{
				fDeltaBitmapView = new SelectionBitmapView();
				fDeltaBitmapView->ForceWidth( fBitmapWidth/2 );
				fDeltaBitmapView->ForceHeight( fBitmapHeight/2 );
				frame->AddObject( fDeltaBitmapView, 1.0f );
			}
			vs->AddObject( frame, 1.0f );

			float refval = CAApp::Settings()->GetFloat( CFG_REFVALUE );
			float scaleval = CAApp::Settings()->GetFloat( CFG_SCALEVALUE );

			frame = new dle::Frame( dle::Frame::FANCY_LOWERED );
			{
				dle::HSplit *hs = new dle::HSplit();
				hs->SetInner( 0 );
				{
					fDeltaSlider = new MiniSlider( new BMessage(MSG_DELTASLIDE), MiniSlider::TRIANGLE_RIGHT, 0, 255 );
					fDeltaSlider->SetValue( (refval/scaleval)*256 );
					hs->AddObject( fDeltaSlider, 1.0f );

					dle::VLine *vl = new dle::VLine( dle::VLine::RAISED );
					hs->AddObject( vl, 1.0f );

					fDeltaLoadView = new LoadView();
					fDeltaLoadView->SetRefValue( refval );
					fDeltaLoadView->SetScale( 1.0f/scaleval );
					hs->AddObject( fDeltaLoadView, 1.0f );

					vl = new dle::VLine( dle::VLine::RAISED );
					hs->AddObject( vl, 1.0f );

					fScaleSlider = new MiniSlider( new BMessage(MSG_SCALESLIDE), MiniSlider::TRIANGLE_LEFT, 1, 255 );
					fScaleSlider->SetValue( int(scaleval*256) );
					hs->AddObject( fScaleSlider, 1.0f );
				}
				frame->AddObject( hs, 1.0f );
			}
			vs->AddObject( frame, 1.0f );
		}
		hs->AddObject( vs, 1.0f );
	}
	return hs;
}

dle::Object *CAWin::GuiStatusBar()
{
	dle::Frame *frame = new dle::Frame( dle::Frame::RAISED );
	frame->InnerSpacing( false );
	{
		dle::HSplit *hs = new dle::HSplit();
		{
			fStatusView = new dle::BStringView( "", false );
			fStatusView->InnerSpacing( false );
			fStatusView->SetHighColor( tint_color(ui_color(B_PANEL_BACKGROUND_COLOR),B_DARKEN_4_TINT) );
			hs->AddObject( fStatusView, 1.0f );

			dle::Space *space = new dle::Space;
			hs->AddObject( space, 1.0f );

			fProgressBar = new dle::ProgressBar;
			fProgressBar->SetInner( 3 );
			fProgressBar->ForceWidth( PROGRESS_BAR_WIDTH );
			hs->AddObject( fProgressBar, 1.0f );
		}
		frame->AddObject( hs, 1.0f );
	}
	return frame;
}

//-----------------------------------------------------------------------------

