/*
 * Copyright (c) 1999, Jesper Hansen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither name of the company nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//-----------------------------------------------------------------------------
//-------------------------------------
//-------------------------------------
namespace dle { class BCheckBox; }

#include "dle/Window.h"
//-----------------------------------------------------------------------------

class ConfigWin : public dle::Window
{
public:
	enum { CFG_CHANGE_PROXY=1, CFG_CHANGE_NETWORK=2 };

	ConfigWin( BMessenger *target, BMessage *message );
	~ConfigWin();

	void Show();

protected:
	bool QuitRequested();
	void MessageReceived( BMessage *msg );

private:
	void ReadConfig();
	void SetConfig( bool save );
	void EnableDisableControls();
	
	BMessenger			*fMessenger;
	BMessage			*fMessage;

	BFilePanel			*fSaveFilePanel;
	BFilePanel			*fRunFilePanel;
	
	BCheckBox			*fProxyCheckBox;
	dle::BTextControl	*fProxyHost;
	dle::BTextControl	*fProxyPort;

	dle::BCheckBox		*fPlaySoundCheckBox;

	dle::BCheckBox		*fSaveFrameCheckBox;
	dle::BTextControl	*fSaveFrameTextControl;
	dle::BButton		*fSaveFrameBrowseButton;

	dle::BCheckBox		*fRunFileCheckBox;
	dle::BTextControl	*fRunFileTextControl;
	dle::BButton		*fRunFileBrowseButton;
};

//-----------------------------------------------------------------------------
