/*
 * Copyright (c) 1999, Jesper Hansen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither name of the company nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//-----------------------------------------------------------------------------
//-------------------------------------
#include <support/DataIO.h>
#include <support/Locker.h>
#include <support/String.h>
class BMessage;
class BMessenger;
//-------------------------------------
//-----------------------------------------------------------------------------

class URL // FIXME: find another name, and move to common
{
public:
	URL( const BString &url );
	
	const BString &Protocol() const { return fProtocol; }
	const BString &Host() const { return fHost; }
	int Port() const { return fPort; }
	const BString &Request() const { return fRequest; }

private:
	BString fProtocol;
	BString fUsername;
	BString fPassword;
	BString fHost;
	uint16	fPort;
	BString fRequest;
};

class HTTPFetch
{
public:
	enum { ERR_UNKNOWN_HOST=B_ERRORS_END+1, };

	HTTPFetch( const char *host, int port=80, const char *proxy_host=NULL, int proxy_port=0 );
	~HTTPFetch();
	
	void ProcessMessage( BMessage *message, BMessenger *messenger );
	
	void KillConnection();

	status_t Get( const char *file, BDataIO *io, BString *mimetype=NULL );
	
private:
	bool	fConnect();
	
	static bool Send( int sock, const char *string );
	static bool Send( int sock, const void *buffer, int length );

	BLocker			fLock;
	
	BMessage		*fMessage;
	BMessenger		*fMessenger;

	BString			fHost;
	int				fPort;

	bool			fProxyUse;
	BString			fProxyHost;
	int				fProxyPort;
	
	BString			fLastModified;
	
	volatile int	fSocket;
	volatile bool	fKillConnection;
};

//-----------------------------------------------------------------------------
