/*
 * Copyright (c) 1999, Jesper Hansen. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither name of the company nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//-----------------------------------------------------------------------------
#ifndef DAMN_DLE_DEBUGVIEW_H
#define DAMN_DLE_DEBUGVIEW_H
//-----------------------------------------------------------------------------
//-------------------------------------
#include <interface/View.h>
#include <support/String.h>
//-------------------------------------
#include "Core.h"
//-----------------------------------------------------------------------------

namespace dle
{
	class ProgressBar : public BView, public Object
	{
	public:
		ProgressBar();

		void SetProgress( float level );
		float GetProgress() const;
		
		void SetProgressColor( const rgb_color &color );
		void SetProgressColor( uint8 r, uint8 g, uint8 b, uint8 a=255 ) { rgb_color c={r,g,b,a}; SetProgressColor(c); }

	protected:
		MinMax2	GetMinMaxSize();
		void SetSize( const BRect &size );

		void Draw( BRect updateRect );

	private:
		void ClipToBar( bool restrict );

		rgb_color	fBackCol;
		rgb_color	fLightCol;
		rgb_color	fDarkCol;
		rgb_color	fBlackCol;
		rgb_color	fProgressCol;
		rgb_color	fProgressDoneCol;

		float		fProgress;
	};
}

//-----------------------------------------------------------------------------
#endif

