#include "Cell.h"
#include "World.h"

#include <stdio.h>

// Constructor
cCell::cCell( BRect frame, cWorld *w )
{
	theBeing = NULL;
	theWorld = w;
	theFrame = frame;
	
	changed = true;
}

// Just a pass through function.
// THis way, the being does not need a pointer to the world
cCell *cCell::GetNextNeighbor( void )
{
	return theWorld->GetNextNeighbor( this );
}

// Return the being in this cell.
// theBeing will be NULL if there isn't any
cBeing* cCell::GetBeing( void )
{
	return theBeing;
}

// Draw the cell
void cCell::Draw( )
{
	theWorld->theView->SetHighColor( 0, 0, 210 );

	// Only try to draw a graphic if we have a being
	if( theBeing )
	{
		BBitmap *picture = theBeing->GetPicture();

		if( picture )
			theWorld->theView->DrawBitmapAsync( picture, theFrame );
		else
			theWorld->theView->FillRect( theFrame );
	}
	else
		theWorld->theView->FillRect( theFrame );
}

// Just take the being out.  Most common use is when the being is just moving away from this cell
void cCell::RemoveBeing( void )
{
	SetHealth( 0 );

	theBeing = NULL;
	
	changed = true;
}

// Kill the being in this cell.
// Someone may have eaten it or it got too old
void cCell::KillBeing( void )
{
	if( theBeing )
		delete theBeing;

	SetHealth( 0 );

	theBeing = NULL;
	
	changed = true;
}

// Assign a being to this cell.
// Replaces the pointer, so KillBeing() should really
// be called if the previous occupant should die.
// (or memory will be lost)
void cCell::SetBeing( cBeing *newBeing )
{
	theBeing = newBeing;

	if( !theBeing )
		SetHealth( 0 );
	else
		SetHealth( theBeing->GetHealth( ) );
		
	changed = true;
}

// Sets the health color border
void cCell::SetHealth( int health )
{
	// Nothing here.  Not yet implemented.
}

// Update the being in this cell
// And redraw the view (if required) to show changes
void cCell::Update( int gen )
{
	if( theBeing )
		theBeing->Update( );

	if( changed )
	{
		Draw( );
		changed = false;
	}
}

// If the being in this cell has not moved,
// let it do it's thing.
// This also kills/removes/etc if needed by the being
void cCell::Run( int gen )
{
	cCell *temp;

	if( theBeing && !theBeing->HasMoved( ) )
	{
		temp = theBeing->MakeMove( gen );

		if( temp && temp != this )
		{
			if( temp->GetBeing( ) )
				temp->KillBeing( );

			temp->SetBeing( theBeing );
			temp->SetHealth( theBeing->GetHealth( ) );
			theBeing->SetCell( temp );
			RemoveBeing( );
		}
		if( !temp )
			KillBeing( );
	}
}

