#ifndef _BEING_H_
#define _BEING_H_

#include <Bitmap.h>
#include <TranslationUtils.h>

// Types of beings
const uint32 BEING_FISH = 'BFsh';
const uint32 BEING_SHARK = 'BShk';
const uint32 BEING_DEATH = 'BDth';

class cCell;

class cBeing
{
	public:
		// Constructor.  Sets up defaults
		cBeing( cCell* );
		// Just returns a pointer to the bitmap for the cell's draw() function
		virtual BBitmap *GetPicture( void );
		// Simply return if this being has moved already
		bool HasMoved( void ) { return made_move; }
		// Do the actual motions for this being
		virtual cCell* MakeMove( int gen );
		// Return the health value of the being
		int GetHealth( void );
		// Set this being's parent cell
		void SetCell( cCell * );
		// Reset any per-generation settings
		void Update( void );
		// Just return this being's type constant
		uint32 GetType( void );

	protected:
		// Hangs on to the bitmap for this being
		BBitmap *thePicture;
		// Keeps track of this being's cell
		cCell *theCell;
		// Keeps track of this being's type code
		uint32 type;
		// Tracks if this cell has been considered for a move yet or not.  Is reset on every new generation.
		bool made_move;
		// All beings have an age
		int age;
		// All beings must die
		int max_age;
		// Tracks internal health amount
		int health;
};

#endif
