#ifndef _CELL_H_
#define _CELL_H_

#include <Bitmap.h>
#include <stdlib.h>
#include <TranslationUtils.h>
#include <View.h>
#include <Window.h>

#include "Being.h"

class cWorld;

class cCell
{
	public:
		// Constructor takes a pointer to the world
		cCell( BRect, cWorld* );
		// Used to draw the cell.
		void Draw( );
		// Returns a pointer to the Being that is in the position or NULL if none.
		cBeing *GetBeing( void );
		// Sets the cell's being (this will overwrite the old being if any.  other code must check first!)
		void SetBeing( cBeing * );
		// Just remove the being from this cell.  Doesn't kill/delete the object.
		void RemoveBeing( void );
		// Actually kills the being.  (deletes the being object)
		void KillBeing( void );
		// This is used to set the border color of the cell according to how much "health" the being inside it has.  100 is max 0 is min.
		void SetHealth( int );
		// Returns this cell's next neighrbor cell (pass-thru to the world)
		cCell *GetNextNeighbor( void );
		// Checks to see if there is a being and has the being move.  It is passed the current generation.
		void Run( int gen );
		// Updates the cell.
		void Update( int gen );

	protected:
		// Keeps track of which being (if any) lives here.  NULL for none
		cBeing *theBeing;
		// Keeps track of the world's position in the universe
		cWorld *theWorld;
		// Keeps track of the cell's frame in the world.
		BRect theFrame;
		// Tracks if this cell has changed anything that will require redraw.
		bool changed;
};

#endif