#include "Fish.h"
#include "Main.h"

cFish::cFish( cCell* c ) : cBeing( c )
{
	thePicture = fishpic;
	
	type = BEING_FISH;

	age = 0;
	
	// Fish specs
	max_age = 5;
	birth_min = 2;
}

// Move the fish around and stuff
cCell* cFish::MakeMove( int gen )
{
	made_move = true;
	age++;

	// Fish too old.  Die.
	if( age >= max_age )
		return NULL;

	cCell *temp = NULL;

	// Look for a good, open cell
	do
	{
		temp = theCell->GetNextNeighbor( );
	}
	while( temp && temp->GetBeing( ) );

	// If no open cells, just stay here.
	if( !temp )
		return theCell;

	// Check if fish can have a baby
	// Also add some randomness
	if( age >= birth_min && ( ( rand( ) % 9 ) <= 7 ) )
	{
		temp->SetBeing( new cFish( temp ) );
		return theCell;
	}
	else
	{
		// Move to cell
		return temp;
	}
}
