#include "Shark.h"
#include "Main.h"

cShark::cShark( cCell *c ) : cBeing( c )
{
	// Use the global pointer to save mem and improve speed
	thePicture = sharkpic;

	// I think therefore I shark
	type = BEING_SHARK;

	age = 0;
	
	// Shark specs
	// Age of shark's last baby
	last_baby_age = 0;
	// Age of last meal
	last_meal = 0;
	// Max age of a shark
	max_age = 7;
	// Max number of years shark can go without eating
	no_eat_max = 5;
	// Min age to breed
	birth_min = 5;
	// Shark must have eaten at the most x years before in order to breed
	birth_eat_min = 2;
	// Shark cannot have had a baby for x years in order to have one now
	birth_baby_min = 3;
}

// See if it can eat the type t
bool cShark::CanEat( uint32 t )
{
	if( t == BEING_FISH )
		return true;

	return false;
}

// Move the shark according to it's rules
cCell* cShark::MakeMove( int gen )
{
	made_move = true;
	age++;

	// Die if old
	if( age >= max_age )
		return NULL;

	// Die if haven't eaten in awhile
	if( age - last_meal >= no_eat_max )
		return NULL;

	cCell *temp = NULL;
	cCell *temp2 = NULL;

	bool eat = false;
	bool done = false;
	bool canmove = false;

	// Look for something to eat
	do
	{
		temp = theCell->GetNextNeighbor( );

		if( temp )
		{
			if( temp->GetBeing( ) && CanEat( temp->GetBeing( )->GetType( ) ) )
				eat = true;

			if( !temp->GetBeing( ) )
			{
				temp2 = temp;
				canmove = true;
			}
		}

		// Ran out of spaces
		if( !temp )
			done = true;
	}
	while( !done && !eat );

	// If no open cells and nothing to eat, just stay here.
	if( done && !canmove && !eat )
		return theCell;

	// Have a baby.  Maybe
	if(	age >= birth_min
		&& age - last_meal < birth_eat_min
		&& age - last_baby_age > birth_baby_min
		&& ( canmove || eat )
		&& ( (rand( ) % 4) == 2 )
	  )
	{
		if( eat )
			temp2 = temp;

		temp2->SetBeing( new cShark( temp2 ) );
		last_baby_age = age;
		return theCell;
	}	

	// This should mean there's a fish to eat in the cell
	if( temp && eat )
	{
		last_meal = age;
		// If the shark is lucky, this fish could have been REALLY good for him and added a year onto his life
		if( rand( ) % 2 == 1 )
			max_age++;
		return temp;
	}

	// Finally, just move someplace.  Temp2 should have a nice place to move to by now.
	return temp2;
}
