#include "World.h"

cWorld::cWorld( BView *v )
{
	theView = v;

	// Set up the world's size
	width = 30;
	height = 30;

	// Configure the graphics
	int boxsize = 25;
	int boxspace = 2;

	generation = 0;

	// Create an array of pointers to cCells
	theCells = new cCell*[width*height];
	// Create a 2D array used when getting neighbors
	neighbor_check = new bool*[width*height];
	// This array is used to track which cells have been worked on
	cell_check = new bool[width*height];
	
	srand( time( NULL ) );

	// Init the neighbor array
	for( int i=0; i<(width*height); i++ )
		neighbor_check[i] = new bool[8];
	// Clear the neighbor array
	ResetNeighbors( );

	// Clear the cell array
	ResetCells( );

	// Define some starting parameters
	int maxdeath = 1;
	int maxshark = 20;
	int maxfish = 50;

	// Used for random number
	int tmp;

	// Initalize the world of cells and tell theView about the graphics Views
	for( int i=0; i<height; i++ )
		for( int j=0; j<width; j++ )
		{
			theCells[(i*width)+j] = new cCell( BRect( (j*boxsize)+boxspace, (i*boxsize)+boxspace, (j*boxsize)+boxsize, (i*boxsize)+boxsize ), this );

			// Randomly populate the world with beings and things
			tmp = rand( ) % 4;
			if( tmp == 2 && maxfish )
			{
				theCells[(i*width)+j] -> SetBeing( new cFish( theCells[(i*width)+j] ) );
				maxfish--;
			}

			if( tmp == 1 && maxshark )
			{
				theCells[(i*width)+j] -> SetBeing( new cShark( theCells[(i*width)+j] ) );					
				maxshark--;
			}

			if( tmp == 3 && maxdeath )
			{
				theCells[(i*width)+j] -> SetBeing( new cPollution( theCells[(i*width)+j] ) );
				maxdeath--;
			}
		}
}

// Run() goes through all the cells.
// Once done, a generation is completed.
void cWorld::Run( void )
{
	int count = 0;
	int num;

	while( count < (width*height)-1 )
	{
		// Pick a free cell randomly
		// This is VERY nasty and time consuming because it has to loop
		// until it finally gets those last couple of numbers
		// It should have something that tracks what has been picked
		// or just step through a random array or something?
		do
		{
			num = rand( ) % (height*width);
		}
		while( cell_check[num] );

		// Mark cell as used
		cell_check[num] = true;

		// Start the life
		theCells[num]->Run( generation );		

		// I dunno.  I thought if I paused a little it would help the random numbers
		// be a tiny bit more random since they are based on clock cycles (I think)
		snooze( rand( ) % 5 );

		// First see if any more cells are open
		count = 0;
		for( int i=0; i<(width*height); i++ )
		{
			if( cell_check[i] )
				count++;
		}
	}

	generation++;

	// Update the cells and reset everything.
	for( int i=0; i<(width*height); i++ )
		theCells[i]->Update( generation );
	
	ResetCells( );
	ResetNeighbors( );
}

int cWorld::GetCellIndex( cCell *c )
{
	// Find which cell c is.
	int count = (width*height)-1;
	while( theCells[count] != c )
	{
		count--;
	}
	
	return count;
}

// Clears all the neighbors and gets ready for a fresh start
void cWorld::ResetNeighbors( void )
{
	for( int i=0; i<(width*height); i++ )
		for( int j=0; j<8; j++ )
			neighbor_check[i][j] = false;
}

// Set all the cells to false so that the next time
// around Run() will find something to move to.
void cWorld::ResetCells( void )
{
	for( int i=0; i<(width*height); i++ )
		cell_check[i] = false;
}

// Returns a pointer to the cell c's next neighbor cell (randomly)
// Or NULL if no more left to return.
cCell* cWorld::GetNextNeighbor( cCell *c )
{
	int num;
	int count = 0;
	int cell = GetCellIndex( c );

	// First see if any are open
	for( int i=0; i<8; i++ )
	{
		if( neighbor_check[cell][i] )
			count++;
	}

	// All full
	if( count == 8 )
		return NULL;
	
	// Otherwise, pick one
	do
	{
		num = rand( ) % 8;
	}
	while( neighbor_check[cell][num] );


	neighbor_check[cell][num] = true;

	num++;

	// Finally calculate which cell was picked and return it
	// Handle all the checks for cells that are to the left
	if( num == 1 || num == 7 || num == 8 )
	{
		if( cell % width == 0 )
			cell += (width-1);
		else
			cell--;
	}

	// Handle all the checks for cells that are to the right
	if( num == 3 || num == 4 || num == 5 )
	{
		if( ((cell+1) % width) == 0 )
			cell -= width;

		cell++;
	}

	// Handle all the checks for cells that are to the top
	if( num == 1 || num == 2 || num == 3 )
	{
		if( cell < width )
			cell = (width*height)-(width-cell);
		else
			cell -= width;
	}

	// Handle all the checks for cells that are to the bottom
	if( num == 5 || num == 6 || num == 7 )
	{
		if( (cell + width) >= (height*width) )
			cell -= (width*(height-1));
		else
			cell += width;
	}

	return theCells[cell];
}

uint cWorld::GetGeneration( void )
{
	return generation;
}

void cWorld::Redraw( void )
{
	for( int i=0; i<(width*height); i++ )
		theCells[i]->Draw( );
}
