#include "myWindow.h"
#include <stdio.h>

// Construct the Window.
myWindow::myWindow( BRect frame, char *title )
		 : BWindow( frame, title, B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL,
		 			B_NOT_ZOOMABLE | B_NOT_RESIZABLE, B_CURRENT_WORKSPACE )
{
	// Create a view to put stuff in.
	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_FULL_UPDATE_ON_RESIZE );
	windowBack ->  SetViewColor( 30, 20, 120 );
	AddChild( windowBack );

	// Create the world.
	theWorld = new cWorld( windowBack );

	timer = new BMessageRunner( this, new BMessage( DA_TIMER ), 1, 1 );
}


// Need this to get any messages sent to this window.
void myWindow::MessageReceived( BMessage *msg )
{
	switch (msg -> what )
	{
		// The message from the timer
		case DA_TIMER:
			if( NeedsUpdate( ) )
				theWorld->Redraw( );

			theWorld->Run( );
			char title[1000];
			sprintf( title, "Generation: %u", theWorld->GetGeneration( ) );
			SetTitle( title );
			
			// This little section here allows the loop to catch other messages if needed.
			// It helps avoid a flood of BMessages to run the world if the computer is too
			// far behind to handle them all.
			delete timer;
			timer = new BMessageRunner( this, new BMessage( DA_TIMER ), 1, 1 );
			break;

		// Handle the default BMessages sent by the system by passing them through to BWindow (it should know what to do with them, so why should you?)
		default:
			BWindow::MessageReceived(msg);
			break;
	};
}


// BeOS is trying to close the window.  Do stuff here and return true or false depending on if
// you want to allow the window to be closed.
bool myWindow::QuitRequested()
{
	delete theWorld;
	delete timer;

	// Send a BMessage to the whole application to quit.
	// This is critical.  Otherwise the application will stay open but the last window was closed.
	// That makes it a bit hard to kill the app.
	// The be_app object is actually a global pointer to your own BApplication (myApp).
	// BeOS creates this for you pretty much just for neat things like this.
	// (Note that be_app is subclassed to your BApplication class.  In this case, myApp.  This is to avoid problems.
	((myApp *)be_app)->PostMessage(B_QUIT_REQUESTED);

	return true;
}
