#ifndef _GENERIC_INPUT_H
#define _GENERIC_INPUT_H

#include <Invoker.h>
#include <Window.h>
#include <View.h>

class BRect;
class BMessage;
class BHandler;
class BTextControl;
class BStringView;

class GButton;
class GManager;

class GenericInputView : public BView
{
	friend class GenericInputWindow;

	public:
		GenericInputView( BRect rect );
};


class GenericInputWindow : public BWindow, public BInvoker
{
	public:
		GenericInputWindow( BRect frame, const char* title, const char* label, const char* OK, const char* cancel, GManager *the_manager, BMessage* = NULL, BHandler* = NULL, 
				const char* initial = NULL, int maxLen = 0, const char* fname = "value");
		~GenericInputWindow();

		virtual void MessageReceived(BMessage* message);
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
		
		virtual void MakeExtraControls( BView*, unsigned int& extraHeight );		
		virtual	bool QuitRequested();
		virtual void Save();

	private:
		GenericInputView *genView;
		BTextControl* personName;
		GButton* SaveButton;
		GButton* CancelButton;
		BStringView* label;	
		BMessage* sndMessage;
		char fieldName[25];
		
		GManager *mManager;
};

#endif
