#ifndef _GIMICQ_CONSTANTS_H__
#define _GIMICQ_CONSTANTS_H__

#include <GraphicsDefs.h>

// Gim-ICQ messages
const uint32 GIMICQ_SIGN_ON					= 'Snon';
const uint32 GIMICQ_LOGIN					= 'LoGn';
const uint32 GIMICQ_LOGOUT					= 'LoGt';
const uint32 GIMICQ_OPEN_IM_WINDOW			= 'Oimw';
const uint32 GIMICQ_ATTEMPT_SEND_IM			= 'Sasm';
const uint32 GIMICQ_NOT_IMPLEMENTED			= 'Nimp';
const uint32 GIMICQ_BUDDY_INVOKED			= 'Bivk';
const uint32 GIMICQ_OPEN_BUDDY_LIST			= 'oBlS';
const uint32 GIMICQ_IM_WINDOW_OPENED		= 'Imwo';
const uint32 GIMICQ_IM_WINDOW_CLOSED		= 'Imwc';
const uint32 GIMICQ_SEND_MESSAGE			= 'SnIm';
const uint32 GIMICQ_CANCEL_SIGN_ON			= 'Cnsn';
const uint32 GIMICQ_LOGIN_STEP				= 'Sstp';
const uint32 GIMICQ_LOGIN_FAILURE			= 'lFlr';
const uint32 GIMICQ_ONCOMING_BUDDY			= 'Bdin';
const uint32 GIMICQ_OFFGOING_BUDDY			= 'Bdot';
const uint32 GIMICQ_BUDDY_STATUS_CHANGE		= 'Bsch';
const uint32 GIMICQ_MY_STATUS_CHANGE		= 'Msch';
const uint32 GIMICQ_SIGN_ON_SUCCESSFUL		= 'SonS';
const uint32 GIMICQ_INCOMING_IM				= 'inIM';
const uint32 GIMICQ_OUTGOING_IM				= 'otIM';
const uint32 GIMICQ_SET_LOGIN_STEP_COUNT	= 'SlSc';
const uint32 GIMICQ_EDIT_BUDDY				= 'eDtB';
const uint32 GIMICQ_SIGN_OFF				= 'sNof';
const uint32 GIMICQ_OPEN_PREFS				= 'oPrf';
const uint32 GIMICQ_RELOAD_PREF_SETTINGS	= 'RlPs';
const uint32 GIMICQ_TRY_ADD_PERSON			= '42ap';
const uint32 GIMICQ_ADD_PERSON				= '43ap';
const uint32 GIMICQ_TRY_CHANGE_PERSON		= '42cp';
const uint32 GIMICQ_CHANGE_PERSON			= '43cp';
const uint32 GIMICQ_TRY_ADD_GROUP			= '42ag';
const uint32 GIMICQ_ADD_GROUP				= '43ag';
const uint32 GIMICQ_TRY_CHANGE_GROUP		= '42cg';
const uint32 GIMICQ_CHANGE_GROUP			= '43cg';
const uint32 GIMICQ_DELETE_PERSONORGROUP	= '42dl';
const uint32 GIMICQ_SEND_NEW_MESSAGE		= 'nMSG';
const uint32 GIMICQ_GET_PERSON_INFO			= 'gPif';
const uint32 GIMICQ_UPDATE_INFO				= 'uINF';
const uint32 GIMICQ_OPEN_USER_WINDOW		= 'oUSw';
const uint32 GIMICQ_CLOSE_WINDOW			= 'cLsw';
const uint32 GIMICQ_PEOPLELIST_COMMIT		= 'PlsC';
const uint32 GIMICQ_OPEN_EMAIL_SEARCH		= 'sE-O';
const uint32 GIMICQ_SEARCH_BY_EMAIL			= 'sE-m';
const uint32 GIMICQ_TOGGLE_HIDDEN			= 'tGHD';
const uint32 GIMICQ_ESEARCH_RESULTS_CLOSED	= 'esc!';
const uint32 GIMICQ_NEXT_CHAT_WINDOW		= 'nC%s';
const uint32 GIMICQ_PREV_CHAT_WINDOW		= 'nC%A';
const uint32 GIMICQ_SEND_ARBITRARY_DATA 	= 'aBdt';
const uint32 GIMICQ_NOW_IDLE				= 'Dew!';
const uint32 GIMICQ_NOW_ACTIVE				= 'Dew?';
const uint32 GIMICQ_SEND_IDLE_PULSE			= 'Dew.';
const uint32 GIMICQ_TOGGLE_DESKBAR_ICON		= 'SQRL';
const uint32 GIMICQ_ATTEMPT_SEND_URL		= 'aURL';
const uint32 GIMICQ_SEND_URL				= 'sURL';
const uint32 GIMICQ_INCOMING_URL			= 'iURL';
const uint32 GIMICQ_OUTGOING_URL			= 'oURL';
const uint32 GIMICQ_UPDATE_MY_INFO			= 'mInF';
const uint32 GIMICQ_FLASH_ON				= 'flON';
const uint32 GIMICQ_FLASH_OFF				= 'flOF';
const uint32 GIMICQ_CHANGE_ENCODING	 		= 'cEnc';
const uint32 GIMICQ_OPEN_NOTES		 		= 'oNts';
const uint32 GIMICQ_SET_ONLINE_NOTIFY		= 'oNNt';
const uint32 GIMICQ_SEND_CLEAR				= 'snCR';
const uint32 GIMICQ_ENABLE_FLASHY_STUFF		= 'eFLs';
const uint32 GIMICQ_ONLINE_NOTIFY			= 'oTFY';
const uint32 GIMICQ_CHANGE_PASSWORD			= 'cPSW';
const uint32 GIMICQ_NEW_USER				= 'cPSW';
const uint32 GIMICQ_USE_THIS_UIN_DUMMY		= 'uUIN';
const uint32 GIMICQ_CLEAR_HISTORY_MEM = 'clHM';
const uint32 GIMICQ_GET_UIN_HISTORY = 'GgHi';
const uint32 GIMICQ_ABOUT           = 'GAbo';
const uint32 GIMICQ_CHAT_WINDOW_ACTIVATED = 'GChA';

const uint32 GIMICQ_LAST_MESSAGE	= 'GLMs';
const uint32 GIMICQ_SHOW_MESSAGE	= 'GSMs';

// Messages for menu commands
const uint32 MENU_FILE_NEW				= 'MFnw';
const uint32 MENU_FILE_OPEN				= 'MFop';
const uint32 MENU_FILE_CLOSE			= 'MFcl';
const uint32 MENU_FILE_SAVE				= 'MFsv';
const uint32 MENU_FILE_SAVEAS			= 'MFsa';
const uint32 MENU_FILE_PAGESETUP		= 'MFps';
const uint32 MENU_FILE_PRINT			= 'MFpr';
const uint32 MENU_FILE_QUIT				= 'MFqu';

// Buddy status: Is someone entering, leaving, idle...?
const uint32 BS_ENTERING = 1;
const uint32 BS_LEAVING = 2;
const uint32 BS_ACTIVE = 4;
const uint32 BS_IDLE = 8;
const uint32 BS_OFFLINE = 16;
const uint32 BS_BYEBYE = 32768;

// max string sizes
const int INTERNAL_NAME_MAX = 50;
const int DISPLAY_NAME_MAX = 200;
const int MESSAGE_MAX = 2048;
const int PASSWORD_MAX = 15;

// the amount of time an item stays bold when it has changed
const int BUDDY_CHANGE_TIME = 15;

// user window modes
const int USER_MESSAGE_TYPE = 1;
const int USER_INFO_TYPE = 2;
const int USER_NOTES_TYPE = 3;

// default protocol definition... for now
const unsigned int AIM_PROTOCOL = 42;

// String constants
extern const char* APP_SIGNATURE;
extern const char* SETTINGS_FOLDER;
extern const char* kVERSION;
extern const char* DESKBAR_SIGNATURE;
extern const char* kViewName;
extern const char* GIM_MENU;

// sound events
const int WS_ENTER = 1;
const int WS_EXIT = 2;
const int WS_MSGSEND = 3;
const int WS_MSGRECEIVE = 4;
const int WS_NEWMSG = 5;
const int WS_NEWMSG2 = 6;
const int WS_LOGON = 7;
const int WS_LOGOFF = 8;
const int WS_RIBBIT = 9;
const int WS_ABOUT = 10;
const int WS_TEMP1 = 11;
const int WS_TEMP2 = 12;
const int WS_TEMP3 = 13;
const int WS_TEMP4 = 14;

const unsigned int MAX_SOUNDS = 15;
// list editor mode
enum editType {
	ET_ADDPERSON,
	ET_ADDGROUP,
	ET_PERSONEDIT,
	ET_GROUPEDIT	
};

/* Colorization constants */
const rgb_color kBlack = {0,0,0,0};
const rgb_color kThis = {255,0,0,0};		// Red  : A statement from THIS aim client
const rgb_color kThat = {0,0,255,0};		// Blue : A statement from the OTHER aim client
const rgb_color kDate = {123,79,5,0};		// Brown: A Date statement
const rgb_color kTime = {43,94,0,0};		// Green: A Time statement

/* Key constants */
const int CR = 13;
const int LF = 10;

#endif
