#ifndef _HISTORY_
#define _HISTORY_

#include "PList.h"

class BMessage;
class BWindow;
class BLocker;

class GManager;
class HistoryIO;
struct chatEntry;

class History {

	public:
		History(GManager *aManager);
		~History();
		
		void Add(BMessage *aMsg);
		void Clear(uint32 aUin, uint32 aOwnUin);
		
		void ReadAll(const uint32 aUin, const uint32 aOwnUin, BWindow *aWindow);
		
		HistoryIO *getHistoryIO() { return mIO; }
	private:
		
		BLocker *mLocker;
		PList<struct chatEntry> mStorage;
		HistoryIO *mIO;
};

#endif