#include <Debug.h>
#include "FancyView.h"

#include <Application.h>
#include <Roster.h>
#include <Window.h>
#include <ScrollBar.h>
#include <string.h>

#include "Say.h"
#include "GManager.h"
#include "Locale.h"

rgb_color kLinkColor = {25,0,225};

//=========================================================

void linkInfo::Set( int32 off, int32 ln, const char* nlink ) {

//	PRINT(("linkInfo::Set\n"));
	delete link;
	link = 0;
	offset = off;
	len = ln;
	
	if( nlink ) {
		link = new char[strlen(nlink) + 1];
		strcpy( link, nlink );
	}
}

//=========================================================

FancyTextView::FancyTextView( BRect frame, const char *name, GManager *the_manager ,
															BRect textRect, uint32 resizingMode, uint32 flags )
		: BTextView( frame, name, textRect, resizingMode, flags )
{
//	PRINT(("FancyTextView::FancyTextView\n"));
	SetViewColor( 255, 255, 255 );
	insertstyle.offset = 0;
	message = NULL;
	Empty = true;
	showFontColorSizes = true;
	showLinks = true;
	autoScrollEnabled = true;
	scroll = NULL;

	mManager = the_manager;
};

//---------------------------------------------------------

void FancyTextView::SetBaseFontAndColor( BFont& font, rgb_color& color, bool SetNow ) {
//	PRINT(("FancyTextView::SetBaseFontAndColor\n"));
	baseFont = font;
	baseColor = color;
	if( SetNow ) {
		insertstyle.font = font;
		insertstyle.color = color;
		SetFontAndColor( &font, B_FONT_ALL, &color );
	}
}

//---------------------------------------------------------

// use later to do on-the-fly formatting, perhaps?
void FancyTextView::InsertText( const char *text, int32 length, int32 offset, const text_run_array *runs ) {
//	PRINT(("FancyTextView::InsertText\n"));

	BTextView::InsertText( text, length, offset, runs );
}
	
//---------------------------------------------------------

void FancyTextView::SetFontAttribute( int32 attrib, bool state ) {
		
//	PRINT(("FancyTextView::SetFontAttribute\n"));
	uint16 curMask = insertstyle.font.Face();
	if( state )
		curMask = ((curMask & B_REGULAR_FACE) ? 0 : curMask) | attrib;
	else
		curMask = (curMask == attrib) ? B_REGULAR_FACE : curMask & (~attrib);			
	insertstyle.font.SetFace( curMask );
	styleChanged = true;
}

//---------------------------------------------------------

void FancyTextView::SetFontColor( rgb_color color ) {
//	PRINT(("FancyTextView::SetFontColor\n"));
	insertstyle.color = color;
	styleChanged = true;	
}

//---------------------------------------------------------

void FancyTextView::SetFontSize( int32 size ) {
//	PRINT(("FancyTextView::SetFontSize\n"));
	insertstyle.font.SetSize( (float)size );
	styleChanged = true;
}

//---------------------------------------------------------

void FancyTextView::SetFontColor( int32 r, int32 g, int32 b ) {
//	PRINT(("FancyTextView::SetFontColor\n"));
	rgb_color newColor;
	newColor.red = r;
	newColor.green = g;
	newColor.blue = b;
	insertstyle.color = newColor;
	styleChanged = true;
}

//---------------------------------------------------------

void FancyTextView::InsertSomeText(const char* text ) {

//	PRINT(("FancyTextView::InsertSomeText\n"));
	textRunStyle masterRec;

	// get the insertion offset for the text
	int32 lastline = CountLines();
	int32 offset = OffsetAt( lastline );

	// Add the style to the list (if it has changed)
	if( styleChanged ) {
		insertstyle.offset = curOffset; // + (int)!Empty;	// if first line, dont add 1
																		// Changed to never add one... 
		insertStyles.Add( insertstyle );
		masterRec.run = insertstyle;
		masterRec.run.offset += offset;
		masterRec.variable = false;
		masterRec.link = false;
		masterStyles.Add( masterRec );
		styleChanged = false;
	}

	// "add" the text (to the internal array, anyway)
	curOffset += StrLen( text );
	strcat( insertText, text );
}

//---------------------------------------------------------

void FancyTextView::ResetFontToBase() {	
//	PRINT(("FancyTextView::ResetFontToBase\n"));
	insertstyle.font = baseFont;
	insertstyle.color = baseColor;
	insertstyle.offset = 0;
	Select( 0, 0 );
	SetFontAndColor( &baseFont, B_FONT_ALL, &baseColor );
	styleChanged = true;
}

//---------------------------------------------------------

void FancyTextView::SetShowFontColorSizes( bool show ) {
//	PRINT(("FancyTextView::SetShowFontColorSizes\n"));
	showFontColorSizes = show;
	if( !Empty )
		RebuildStyles();
}

//---------------------------------------------------------

void FancyTextView::SetShowLinks( bool show ) {
//	PRINT(("FancyTextView::SetShowLinks\n"));
	showLinks = show;
	if( !Empty )
		RebuildLinks();
}

//---------------------------------------------------------

void FancyTextView::SetAutoScrollEnabled( bool enabled ) {
//	PRINT(("FancyTextView::SetAutoScrollEnabled\n"));
	autoScrollEnabled = enabled;
}

//---------------------------------------------------------

void FancyTextView::RebuildStyles() {

//	PRINT(("FancyTextView::RebuildStyles\n"));
	textRunStyle thisRec, nextRec;
	bool keepGoing, atBottom = false;
	const unsigned blockSize = 150;
	uint32 start = 0, stop = 0, counter = 0;
	float baseFontSize = baseFont.Size();
	
	// check and see if we are at the bottom of the BTextView
	if( scroll == NULL ) scroll = ScrollBar( B_VERTICAL );
	if( scroll && autoScrollEnabled ) {
		float scrMin, scrMax;
		scroll->GetRange( &scrMin, &scrMax );
		if( scroll->Value() == scrMax )
			atBottom = true;
	}	
	
	// allocate some room for the text_run_array
	text_run_array* newStyles = (text_run_array*)malloc( sizeof(text_run_array) +
								(sizeof(text_run) * (blockSize - 1)));
	newStyles->count = 0;

	// go through all the master records (in blocks of size spec'd by blockSize)
	keepGoing = masterStyles.First(thisRec);
	while( keepGoing ) {

		// grab the next record
		keepGoing = masterStyles.Next(nextRec);

		// assign the stop value
		stop = keepGoing ? nextRec.run.offset : TextLength();
					
		// When to LEAVE the coloring... if this block is:
		// 1. not variable
		//  -- or --
		// 2. showFontColorSizes is ON
		//  -- or --
		// 3. This is a link, and links are on

		// leave the original formatting there
		if( !thisRec.variable || showFontColorSizes ) {
			newStyles->runs[counter] = thisRec.run;
			newStyles->runs[counter].offset -= start;
		}

		// otherwise, turn it off
		else {
			newStyles->runs[counter] = thisRec.run;
			newStyles->runs[counter].offset -= start;
			newStyles->runs[counter].font.SetSize(baseFontSize);
			if( !(thisRec.link && showLinks) )
				newStyles->runs[counter].color = baseColor;
			else
				newStyles->runs[counter].color = kLinkColor;
		}

		// if we've reached the end of the blocksize, commit the changes
		if( (counter + 1) == blockSize ) {
			newStyles->count = blockSize;
			SetRunArray( start, stop, newStyles );
			start = nextRec.run.offset;
			counter = 0;
		} else
			++counter;

		// assign the next record
		thisRec = nextRec;
	}
	
	// if there are any remaining styles, commit them too
	if( counter ) {
		newStyles->count = counter;
		SetRunArray( start, stop, newStyles );
	}
	
	// do the autoscroll, if needed
	if( atBottom && autoScrollEnabled )
		ScrollToBottom();
	
	// free the text_run_array
	free(newStyles);
}

//---------------------------------------------------------

void FancyTextView::RebuildLinks() {

//	PRINT(("FancyTextView::RebuildLinks\n"));
	textRunStyle thisRec, nextRec;
	bool keepGoing;
	uint32 start, stop;

	// set the link style basics
	text_run_array* linkStyle = (text_run_array*)malloc( sizeof(text_run_array) );
	linkStyle->count = 1;
	linkStyle->runs[0].offset = 0;

	// go through all the master records looking for links
	keepGoing = masterStyles.First(thisRec);
	while( keepGoing ) {

		// grab the next record
		keepGoing = masterStyles.Next(nextRec);

		// assign the start/stop values
		start = thisRec.run.offset;
		stop = keepGoing ? nextRec.run.offset : TextLength();
		
		// if it's a link, deal with it...
		if( thisRec.link ) {

			// set the "appropriate" style info, and commit it
			linkStyle->runs[0] = thisRec.run;
			linkStyle->runs[0].offset = 0;
			if( !(!thisRec.variable || showFontColorSizes) ) {
				linkStyle->runs[0].font.SetSize(baseFont.Size());
				linkStyle->runs[0].color = baseColor;
			}
			if( showLinks )
				linkStyle->runs[0].color = kLinkColor;
			SetRunArray( start, stop, linkStyle );
		}

		// assign the next record
		thisRec = nextRec;
	}
	
	// free the text_run_array
	free( linkStyle );
}

//---------------------------------------------------------

void FancyTextView::ClearInsertStuff() {

//	PRINT(("FancyTextView::ClearInsertStuff\n"));
	// Clear all the saved font states, and NULL out the insert string
	ResetFontToBase();	
	insertStyles.Clear();
	curOffset = 0;
	styleChanged = false;	

	// Only add a beginning line break if the textview is empty
	if( !Empty ) {
		insertText[0] = '\n';
		insertText[1] = '\0';
	} else
		insertText[0] = '\0';
}

//---------------------------------------------------------

void FancyTextView::AddStatement() {

//	PRINT(("FancyTextView::AddStatement\n"));
	int32 number_of_runs = (int32)insertStyles.Count();
	int32 lineCount, lastOffset;
	bool doAutoScroll = true;
	int32 emptyOffset = 0;
	text_run temp;

	// Get the scrollbar position... this is the part where we do autoscroll, but only 
	//   if the scrollbar is already at the bottom. That way it won't get annoying.
	if( scroll == NULL ) scroll = ScrollBar( B_VERTICAL );
	if( scroll ) {
		float scrMin, scrMax;
		scroll->GetRange( &scrMin, &scrMax );
		if( scroll->Value() != scrMax )
			doAutoScroll = false;
	}

	// allocate some room for the text_run_array
	text_run_array* styles = (text_run_array*)malloc( sizeof(text_run_array) +
							(sizeof(text_run) * (number_of_runs - 1)));

	// if the view isn't empty, then we have to offset everything by one
	//  to account for the newline inserted at the start of each statement
	if( !Empty )
		emptyOffset = 1;
	
	// fill in the individual text_runs
	styles->count = number_of_runs;
	insertStyles.First(temp);
	for( int32 i = 0; i < number_of_runs; ++i ) {
		if( i )
			temp.offset += emptyOffset;
		styles->runs[i] = temp;
		insertStyles.Next(temp);
	}
		
	// Get the offset of the last line
	lineCount = CountLines();
	lastOffset = OffsetAt( lineCount );

	// Add the silly thing... if there are no text_runs, don't use styles
	if( number_of_runs )
		Insert( lastOffset, insertText, strlen(insertText), styles );
	else
		Insert( lastOffset, insertText, strlen(insertText) );
	
	// do the autoscroll, if needed
	if( autoScrollEnabled && doAutoScroll )
		ScrollToBottom();
		
	// Prepare to start over
	Empty = false;
	ClearInsertStuff();
	free( styles );
}

//---------------------------------------------------------

void FancyTextView::ScrollToBottom() {

//	PRINT(("FancyTextView::ScrollToBottom\n"));
	int32 lineCount, lastOffset;

	// find the offset of the last line (the insertion point)
	lineCount = CountLines();
	lastOffset = OffsetAt( lineCount );
	
	// now scroll so that it's visible
	ScrollToOffset( lastOffset );
}

//---------------------------------------------------------

void FancyTextView::AddStyledText( char* text, styleList insStyles, bool saveStyles ) {

//	PRINT(("FancyTextView::AddStyledText\n"));
	// vars
	text_run single, blank;
	gTextElement element;
	bool keepGoing, linkWaiting = false;
	unsigned mask, smask;
	rgb_color color1;
	gColor color2;
	int32 fontMask, offset = 0;
	linkInfo nLink;
	textRunStyle masterRec;

	// make the "blank" insert style
	blank.font = baseFont;
	blank.color = baseColor;

	// get the insertion offset for the text
	int32 lastline = CountLines();
	offset = OffsetAt( lastline );
	if( !Empty )
		++offset;
		
	// if there aren't any styles, set it to the "blank" style
	if( !insStyles->Count() ) {
		single = blank;
		single.offset = curOffset;
		masterRec.run = single;
		masterRec.run.offset += offset;
		masterRec.variable = saveStyles;
		masterRec.link = false;
		insertStyles.Add( single );
		masterStyles.Add( masterRec );
	}

	// go through all the styles
	keepGoing = insStyles->First( element );
	while( keepGoing ) {

		// set the offset and get the mask
		single = blank;
		single.offset = element.Offset() + curOffset;
		mask = element.Mask();

		// is it blank?
		if( mask == TE_BLANK ) {
			single.font = baseFont;
			single.color = baseColor;
		}

		// handle font attributes (bold, italic, etc.)
		if( mask & TE_FONTSTYLE ) {
			fontMask = 0;
			smask = element.FontStyle();
			if( smask & ST_BOLD )
				fontMask |= B_BOLD_FACE;
			if( smask & ST_ITALIC )
				fontMask |= B_ITALIC_FACE;
			if( smask & ST_UNDERLINE )
				fontMask |= B_UNDERSCORE_FACE;
			single.font.SetFace( fontMask );
		} else
			single.font.SetFace( B_REGULAR_FACE );

		// handle font size	
		if( showFontColorSizes )
			if( mask & TE_FONTSIZE )
				single.font.SetSize( element.FontSize() );
			else
				single.font.SetSize( blank.font.Size() );

		// handle font color
		if( showFontColorSizes && (mask & TE_FONTCOLOR) ) {
			color2 = element.FontColor();
			MakeRGBColor( color2, color1 );
			single.color = color1;		
		}

		// handle links
		if( mask & TE_LINK ) {
			if( linkWaiting ) {
				nLink.len = offset + single.offset - nLink.offset;
				links.Add( nLink );
				linkWaiting = false;
			}		
			//single.color = kLinkColor;
			nLink.offset = single.offset + offset;
			nLink.Set( single.offset + offset, 0, element.Link().Link() );
			linkWaiting = true;
		} else {
			if( linkWaiting ) {
				nLink.len = offset + single.offset - nLink.offset;
				links.Add( nLink );
				linkWaiting = false;
			}
		}

		// add the style, and keep going if we can
		masterRec.run = single;
		masterRec.run.offset += offset;
		masterRec.variable = saveStyles;
		masterRec.link = bool(mask & TE_LINK);
		masterStyles.Add( masterRec );
		bool sdfdf = false;
		if( mask & TE_LINK )
			sdfdf = true;
		if( sdfdf && showLinks )
			single.color = kLinkColor;
		insertStyles.Add( single );
		keepGoing = insStyles->Next( element );
	}	

	// insert it
	styleChanged = false;
	InsertSomeText( text );
}

//---------------------------------------------------------

void FancyTextView::MakeRGBColor( gColor& color2, rgb_color& color1 ) {
//	PRINT(("FancyTextView::MakeRGBColor\n"));
	color1.red = color2.R();
	color1.green = color2.G();
	color1.blue = color2.B();
}

//---------------------------------------------------------

uint32 FancyTextView::StrLen(const char* str ) {
//	PRINT(("FancyTextView::StrLen\n"));
	return (uint32)strlen(str);
}

//---------------------------------------------------------

void FancyTextView::MouseMoved( BPoint where, uint32 code, const BMessage *msg ) {

//	PRINT(("FancyTextView::MouseMoved\n"));
	int32 moveOffset = OffsetAt(where);
	bool getNext;
	linkInfo thisLink;
	
	// if links aren't on, forget about all this
	if( !showLinks ) {
		BTextView::MouseMoved(where, code, msg);
		return;
	}	

	// start from the bottom, since that's where the link is likely to be
	getNext = links.Last( thisLink );
	while( getNext ) {
			
		// check and see if we are over a link
		if( moveOffset >= thisLink.offset && moveOffset < thisLink.offset + thisLink.len ) {
			be_app->SetCursor(B_HAND_CURSOR);
			return;
		}
		getNext = links.Prev( thisLink );
	}
	
	BTextView::MouseMoved(where, code, msg);
}

//---------------------------------------------------------

void FancyTextView::MouseDown( BPoint where ) {

//	PRINT(("FancyTextView::MouseDown\n"));
	bool getNext, found = false;
	linkInfo thisLink;
	int32 clickOffset = OffsetAt(where);

	// if links aren't on, forget about all this
	if( !showLinks ) {
		BTextView::MouseDown(where);
		return;
	}

	// make sure this window has the focus
	MakeFocus( true );

	// start from the bottom, since that's where the link is likely to be
	getNext = links.Last( thisLink );
	while( getNext ) {

		// check and see if this was the link we clicked on
		if( clickOffset >= thisLink.offset && clickOffset < thisLink.offset + thisLink.len ) {
			found = true;
			break;
		}
		getNext = links.Prev( thisLink );
	}

	if( found ) {
		Select( thisLink.offset, thisLink.offset + thisLink.len );
		Window()->UpdateIfNeeded();
		Open( thisLink.link );
	}

	// call the original implementation...
	BTextView::MouseDown(where);
}

//---------------------------------------------------------

void FancyTextView::Open( char* thelink ) {

//	PRINT(("FancyTextView::Open\n"));
	status_t result;
	
	// the "header" characters
	char header[15];
	
	// check for "http://"
	strncpy( header, thelink, 7 );
	header[7] = '\0';
	if( strcasecmp(header, "http://") == 0 ) {
		result = be_roster->Launch( "text/html", 1, &thelink );
		if( (result != B_NO_ERROR) && (result != B_ALREADY_RUNNING) ) {
			Say( mManager -> _("text50") );
		}
		return;
	}
	
	// check for "mailto:"
	strncpy( header, thelink, 7 );
	header[7] = '\0';
	if( strcasecmp(header, "mailto:") == 0 ) {
		be_roster->Launch("text/x-email", 1, &thelink);
	}
}

//---------------------------------------------------------

void FancyTextView::Clear() {
//	PRINT(("FancyTextView::Clear\n"));
	SetText("");
	links.Clear();
	insertstyle.offset = 0;
	message = NULL;
	Empty = true;
	insertStyles.Clear();
	masterStyles.Clear();
}

//---------------------------------------------------------