#include <Debug.h>
#include "GButton.h"

GButton::GButton(BRect frame , const char *name, const char *label, BMessage *message, uint32 resizeMask, uint32 flags):
				 BButton(frame ,name, label, message, resizeMask , flags) {

	uint32 new_mask = ResizingMode() & 0x0f0f;
	
	if( !(new_mask ^ B_FOLLOW_LEFT) ) {
		ResizeRight( Frame() );
		
	} else if( !(new_mask ^ B_FOLLOW_RIGHT) ) {
		ResizeLeft( Frame() );
	
	} else if( !(new_mask ^ B_FOLLOW_H_CENTER) ) {
		ResizeLeftRight( Frame() );
	
	} else if( !(new_mask ^ B_FOLLOW_LEFT_RIGHT) ) {
		ResizeLeftRight( Frame() );
	
	}

}

void GButton::ResizeLeft(BRect the_frame) {

	float width, height;
	float cur_width = the_frame.Width();
	GetPreferredSize( &width, &height );
	
	ResizeBy( width-cur_width, 0);
	MoveBy( -width+cur_width, 0);

}

void GButton::ResizeRight(BRect the_frame) {

	float width, height;
	float cur_width = the_frame.Width();
	GetPreferredSize( &width, &height );
	
	ResizeBy( width-cur_width, 0);

}

void GButton::ResizeLeftRight(BRect the_frame){

	float width, height;
	float cur_width = the_frame.Width();
	GetPreferredSize( &width, &height );
	
	ResizeBy( width-cur_width, 0);
	MoveBy( (-width+cur_width)/2, 0);

}
