#include <Debug.h>
#include "NotesEditor.h"

#include <View.h>
#include <ScrollView.h>
#include <TextView.h>
#include <StringView.h>
#include <Box.h>
#include <String.h>
#include <File.h>
#include <Path.h>

#include "GButton.h"
#include "MiscStuff.h"
#include "GManager.h"
#include "WindowManager.h"
#include "ProtocolManager.h"
#include "Locale.h"
#include "Prefs.h"

NotesEditor::NotesEditor( BRect frame, unsigned u, const char* nick, GManager *the_manager )
			: BWindow( frame, "Notes", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	PRINT(("NotesEditor::NotesEditor\n"));
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	uin = u;
	
	BString temp;
	BString title = _("title5");
	title +=": ";
	title += nick;
	SetTitle( title.String() );

	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	//windowBack -> SetViewColor( B_TRANSPARENT_32_BIT );
	AddChild( windowBack );
	//windowBack->SetViewBitmap( newBitmap );

	float minW, maxW, minH, maxH;

	GetSizeLimits( &minW, &maxW, &minH, &maxH );
	SetSizeLimits( 457, maxW, 217, maxH );

	BRect a_rect;
	a_rect = windowBack -> Bounds();
	a_rect.right -= 5;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 10;
	a_rect.top = a_rect.bottom - 20;
	CancelButton = new GButton( a_rect , "buttonRun", _("cancelbutton") , new BMessage(B_CANCEL) );
	CancelButton->SetTarget(this);
	windowBack -> AddChild( CancelButton );
	
	a_rect.right -= CancelButton -> Bounds().Width() + 7;
	a_rect.left = a_rect.right - 80;
	SaveButton = new GButton( a_rect , "buttonRun", _("savebutton") , new BMessage(B_OK) );
	SaveButton->SetTarget(this);
	SaveButton->MakeDefault( true );
	windowBack -> AddChild( SaveButton );

	// make the notes editor/label
	BFont chatFont = be_plain_font;
	chatFont.SetSize( 12.0 );
	BRect txbounds = windowBack->Bounds();
	txbounds.InsetBy(8,6);
	txbounds.top += 16;
	txbounds.bottom -= 42;
	txbounds.right -= B_V_SCROLL_BAR_WIDTH;
	BRect txrect = txbounds;
	txrect.OffsetTo(0,0);
	txrect.InsetBy(4,4);
	notes = new BTextView( txbounds, "notes", txrect, B_FOLLOW_NONE, B_PULSE_NEEDED | B_WILL_DRAW | B_NAVIGABLE );
	notes->SetFontAndColor( &chatFont );
	notes->SetMaxBytes( 16384 );
	notesLabel = new BStringView( BRect(8,0,300,20), "label2", _("label60") );
	notesLabel->SetFontSize(12);
	windowBack->AddChild( notesLabel );
	windowBack->AddChild(notes_scroller = new BScrollView("notes_scroll_view", notes,
						B_FOLLOW_NONE, 0, false, true ));

	BRect bounds = windowBack->Bounds();
	BBox* divider = new BBox(BRect(11,160,bounds.right-11,162),"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	windowBack->AddChild( divider );

	LoadNotes();
	notes->MakeFocus(true);
}


void NotesEditor::MessageReceived( BMessage *msg )
{
	PRINT(("NotesEditor::MessageReceived\n"));
	switch (msg -> what )
	{
		case B_OK:
			Save();
			
		case B_CANCEL:
			PostMessage( B_QUIT_REQUESTED );
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

bool NotesEditor::QuitRequested()
{
	PRINT(("NotesEditor::QuitRequested\n"));
	mManager -> windows -> CloseGeneralWindow(this);

	return(true);
}


// the cancel function
void NotesEditor::DispatchMessage( BMessage* msg, BHandler* handler ) {

	PRINT(("NotesEditor::DispatchMessage\n"));
	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN && msg->HasString("bytes") ) {
	
	if( msg->FindString("bytes")[0] == B_ENTER ) {

			// mod+enter... depends on pref
			if( modifiers() & B_COMMAND_KEY ) {
				//if( !enterIsNewline ) {
					//theDesc->Insert("\n");
					//theDesc->ScrollToSelection();
					//return;
				//}
				// not a newline insert, so make it "un-mod-ed"
				msg->ReplaceInt32( "modifiers", 0 );
			}

			// shift-enter always inserts a line break
			else if( modifiers() & B_SHIFT_KEY ) {
				notes->Insert("\n");
				notes->ScrollToSelection();
				return;
			}

			// plain old enter... depends on pref
			else {
				//if( enterIsNewline ) {
					notes->Insert("\n");
					notes->ScrollToSelection();
					return;
				//}
			}
		}
	
		if( msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}

		else if( msg->FindString("bytes")[0] == B_TAB ) {
			if( (modifiers() == 0 || modifiers() == 32) && notes->IsFocus() ) {
				SaveButton->MakeFocus(true);
				return;
			}
		}
	}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}


void NotesEditor::Save() {

	PRINT(("NotesEditor::Save\n"));
	char filename[2048];
	char* text;
	FILE *ptr;

	char userNotesDir[100];
	sprintf( userNotesDir, "notes-%lu", mManager -> p_comm->GetUin() );

	BPath path;
	BFile file;
	MakeFilenameFromUIN( filename,  mManager -> p_comm->GetUin(), "notes" );
	mManager->prefs->FindConfigFile( userNotesDir, filename, &file, B_WRITE_ONLY | B_CREATE_FILE, &path );
	file.Unset();

	ptr = fopen( path.Path(), "w" );
	if( ptr != 0 ) {
		text = const_cast<char*>(notes->Text());
		while( *text ) {
			fprintf( ptr, "%c", *text );
			text++;
		}
		fclose( ptr );
	}
}


void NotesEditor::LoadNotes()
{
	PRINT(("NotesEditor::LoadNotes\n"));
	FILE* ptr;
	char filename[2048];
	char gnotes[16384];
	int i = 0;
	char tmpchar;
	
	char userNotesDir[100];
	sprintf( userNotesDir, "notes-%lu", mManager -> p_comm->GetUin() );
	BPath path;
	BFile file;
	MakeFilenameFromUIN( filename,  mManager -> p_comm->GetUin(), "notes" );
	mManager->prefs->FindConfigFile( userNotesDir, filename, &file, B_READ_ONLY, &path );
	file.Unset();

	// open the people file
	ptr = fopen( path.Path(), "r" );
	if( ptr == 0 )
		return;
		
	tmpchar = getc( ptr );
	while( tmpchar != -1 ) {
		gnotes[i++] = tmpchar;
		tmpchar = getc( ptr );
	}
	gnotes[i++] = '\0';
	notes->SetText( gnotes, i );
	fclose( ptr );
}

