#include <Debug.h>
#include "SendURL.h"

#include <View.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Entry.h>
#include <File.h>
#include <String.h>

#include "DataContainer.h"
#include "GButton.h"
#include "Say.h"
#include "GManager.h"
#include "Gicq.h"
#include "WindowManager.h"
#include "Locale.h"

SendURLWindow::SendURLWindow( BRect frame, unsigned u, const char* name, uint32 enc, GManager *the_manager )
			 : BWindow( frame, "SendURLWindow", B_TITLED_WINDOW, B_NOT_RESIZABLE )
{

	mManager = the_manager;	
	mLocale = mManager -> mLocale;
		
	BString temp;
	BScrollView* textscrollview;
	
	uin = u;
	encoding = enc;

	temp = _("title8");
	temp += " ";
	temp += name;
	SetTitle( temp.String() );

	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	AddChild( windowBack );
	
	temp = _("label140");
	temp += ":";
	theURL = new BTextControl( BRect(5,5,250,25), "stuff", temp.String(), "http://", NULL, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE_JUMP );
	theURL->TextView()->SetMaxBytes( 250 );
	theURL->SetDivider( 30.0 );
	windowBack->AddChild( theURL );

	BRect textframe( 8, 32, 248, 120 );
	textframe.right -= B_V_SCROLL_BAR_WIDTH;
	BRect textrect = textframe;
	textrect.OffsetTo( 0, 0 );	
	textrect.InsetBy( 3, 3 );
	theDesc = new BTextView( textframe, "text_view", textrect, B_FOLLOW_ALL,
								  B_PULSE_NEEDED | B_WILL_DRAW | B_NAVIGABLE );
	theDesc->SetStylable( false );
	theDesc->SetMaxBytes( 100 );	
	BFont testFont = be_plain_font;
	testFont.SetSize(12.0);
	theDesc->SetFontAndColor( &testFont );
	windowBack->AddChild(textscrollview = new BScrollView("text_scroll_view", theDesc,
				B_FOLLOW_LEFT_RIGHT, 0, false, true));
	
	BRect a_rect;
	a_rect = windowBack -> Bounds();
	a_rect.right -= 5;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 10;
	a_rect.top = a_rect.bottom - 20;
	buttonCancel = new GButton( BRect( 181, 128, 251, 148 ), "buttonRun", _("cancelbutton"),
															new BMessage(B_CANCEL) );
	buttonCancel->SetTarget(this);
	windowBack -> AddChild( buttonCancel );	

	a_rect.right -= buttonCancel -> Bounds().Width() + 7;
	a_rect.left = a_rect.right - 80;
	buttonOK = new GButton( a_rect , "buttonRun", _("sendbutton"),
													new BMessage((unsigned long)B_OK) );
	buttonOK->SetTarget(this);
	buttonOK->MakeDefault(true);
	windowBack -> AddChild( buttonOK );
	
	buttonCancel = new GButton( BRect( 181, 128, 251, 148 ), "buttonRun", _("cancelbutton"),
															new BMessage(B_CANCEL) );
	buttonCancel->SetTarget(this);
	windowBack -> AddChild( buttonCancel );	
	
	theURL->MakeFocus(true);
	theURL->TextView()->Select(7,7);
}


void SendURLWindow::MessageReceived( BMessage *msg )
{
	char bigtext[1024], bigtext2[1024];
	int32 srcLen, destLen = 1048, state = 0;
	entry_ref ref;
   	BFile *bf;
   	ssize_t size;
   	char url[300];

	switch (msg -> what )
	{
		case B_OK: {
			if( strlen(theURL->Text()) == 0 || strcmp(theURL->Text(),"http://") == 0 ) {
				Say( _("text180") );
				theURL->MakeFocus(true);
				break;
			}
			
			// prepare text here
			UnFixLineBreaks( bigtext, const_cast<char*>(theDesc->Text()) );
			srcLen = strlen( bigtext );
			convert_from_utf8( encoding, bigtext, &srcLen, bigtext2, &destLen, &state );
			bigtext2[destLen] = '\0';

			// send message here
			BMessage* m = new BMessage( ICQ_URL_MESSAGE );
			m->AddInt32( "TO", (int32)uin );
			m->AddString( "TEXT", bigtext2 );
			m->AddInt32( "LENGTH_TEXT", destLen );
			m->AddString( "URL", theURL->Text() );
			m->AddInt32( "LENGTH_URL", (int32)strlen(theURL->Text()) );
			mManager -> icq -> PostMessage( m );
			
			m = new BMessage( GIMICQ_OUTGOING_URL );
			m->AddString( "TEXT", theDesc->Text() );
			m->AddString( "URL", theURL->Text() );
			m->AddInt32("wtype",(int32)USER_MESSAGE_TYPE);
			m->AddInt32( "UIN",(int32)uin );
			mManager -> windows -> SendBuddyListMessage( m );

		}
			
		case B_CANCEL:
			QuitRequested();
			Close();		
			break;

 		case B_SIMPLE_DATA:
			// Check if the dragged is from NetPositive or whatever
			if( msg->HasString( "be:url" ) )
			{
				//Say( (char*)msg->FindString( "be:url" ) );
				theURL->SetText( msg->FindString( "be:url" ) );
			}
			else
			{
				// See if there is a META:url on the dragged file
				if( msg->FindRef("refs", &ref) == B_OK )
				{
					bf = new BFile( &ref, B_READ_ONLY );
					size = bf -> ReadAttr( "META:url", B_STRING_TYPE, 0, (void*)&url ,300 );

					// Make sure there really is something here to deal with
					if( size )
					{
						url[size] = '\0';
						//Say( url );
						theURL->SetText( url );
					}
					delete bf;
				}
				else
				{
					// Call inherited if we didn't handle the message
					BWindow::MessageReceived(msg);
				}
   			}
   			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

bool SendURLWindow::QuitRequested()
{
	mManager -> windows -> CloseGeneralWindow(this);

	return(true);
}


// the cancel function
void SendURLWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN && msg->HasString("bytes") ) {
	
	if( msg->FindString("bytes")[0] == B_ENTER ) {

			// mod+enter... depends on pref
			if( modifiers() & B_COMMAND_KEY ) {
				//if( !enterIsNewline ) {
					//theDesc->Insert("\n");
					//theDesc->ScrollToSelection();
					//return;
				//}
				// not a newline insert, so make it "un-mod-ed"
				msg->ReplaceInt32( "modifiers", 0 );
			}

			// shift-enter always inserts a line break
			else if( modifiers() & B_SHIFT_KEY ) {
				theDesc->Insert("\n");
				theDesc->ScrollToSelection();
				return;
			}

			// plain old enter... depends on pref
			else {
				//if( enterIsNewline ) {
					theDesc->Insert("\n");
					theDesc->ScrollToSelection();
					return;
				//}
			}
		}
	
		if( msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}

		else if( msg->FindString("bytes")[0] == B_TAB ) {
			if( (modifiers() == 0 || modifiers() == 32) && theDesc->IsFocus() ) {
				buttonOK->MakeFocus(true);
				return;
			}
		}
	}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}


void SendURLWindow::UnFixLineBreaks( char* buffer, char* input ) {

	DataContainer Message;
	char *i, *q;
	char value[1024];
	int l = 1;

	// parse the message, looking for newlines, and insert <br>'s instead
	//i = q = (char*)msg->FindString("message");
	i = q = input;
	if( i ) {
		while( *i ) {
			if( *i == char(10) ) {
				strncpy( value, q, l );
				value[l-1] = '\0';
				Message << value;
				Message << (unsigned char)CR;
				Message << (unsigned char)LF;
				l = 0;
				q = i+1;
			}
			++i; ++l;
		}
		if( i != q )
			Message << q;
	}
	strncpy( buffer, Message.c_ptr(), Message.length() );
	buffer[Message.length()] = '\0';
}

