#include <Debug.h>
#include "UpdateInfo.h"

#include <View.h>
#include <TextControl.h>
#include <MenuField.h>
#include <MenuItem.h>
#include <ScrollView.h>
#include <TextView.h>
#include <TabView.h>
#include <Menu.h>
#include <PopUpMenu.h>
#include <StringView.h>
#include <String.h>

#include <stdlib.h>

#include "GButton.h"
#include "Timezone.h"
#include "GManager.h"
#include "Gicq.h"
#include "WindowManager.h"
#include "Prefs.h"
#include "Locale.h"

//libicq2000
#include <libicq2000/userinfoconstants.h>

//--------------------------global-----------------------

bool
global_code_find( CountryMenuItem *aItem, void *aArg )
{
	int32 ccode = *(static_cast<unsigned short *>(aArg) );
	return (aItem->GetCode() == ccode );
}


//--------------------------class------------------------

//---------------------------------------------------------

UpdateInfoWindow::UpdateInfoWindow( BRect frame, GManager *the_manager )
				: BWindow( frame, "Update Info", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;
	
	BString temp;

	BMessage* yesNo;
	BMessage* countriesMsg;
	BMessage* sexMsg;

	BTab* tab;
	BTabView *tabView; 
	BRect r = Bounds();
	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	AddChild( windowBack );	

	// Add the tabview control
	r.InsetBy( 4, 4 );
	r.bottom -= 34;
	tabView = new BTabView(r, "tab_view"); 
	tabView->SetViewColor( 216, 216, 216 );
	windowBack->AddChild( tabView );
	BRect bottomrect = Bounds();
	bottomrect.InsetBy(4,4);
	bottomrect.top = r.bottom + 4;
	
	// Add the tabs themselves
	r = tabView->Bounds();
	r.InsetBy(5,5); 
	r.bottom -= tabView->TabHeight(); 

	// General tab
	tab = new BTab(); 
	tabView->AddTab( regView = new BView(r, "stuff", B_FOLLOW_ALL_SIDES, B_WILL_DRAW ), tab ); 
	regView->SetViewColor(216,216,216);
	tab->SetLabel("Normal"); 
	
	// Chat Window prefs tab
	tab = new BTab(); 
	tabView->AddTab( extView = new BView(r, "stuff", B_FOLLOW_ALL_SIDES, B_WILL_DRAW ), tab );
	extView->SetViewColor(216,216,216);
	tab->SetLabel("Extended");
	
	// Connection prefs tab
	tab = new BTab(); 
	tabView->AddTab( profView = new BView(r, "stuff", B_FOLLOW_ALL_SIDES, B_WILL_DRAW ), tab );
	profView->SetViewColor(216,216,216);
	tab->SetLabel("Profile");

	temp = _("label150");
	temp += ":";
	BRect bounds = regView->Bounds();
	nickEdit = new BTextControl(BRect(7, 10, bounds.right - 7, 30), "nick", temp.String() , "", 0);
	nickEdit->TextView()->SetMaxBytes(20);
	nickEdit->SetFont(be_bold_font);
	nickEdit->SetFontSize(11);
	nickEdit->SetDivider(75);
	regView->AddChild( nickEdit );
	
	temp = _("label151");
	temp += ":";
	firstEdit = new BTextControl(BRect(7, 35, bounds.right - 7, 55), "first", temp.String() , "", 0);
	firstEdit->TextView()->SetMaxBytes(20);
	firstEdit->SetFont(be_bold_font);
	firstEdit->SetFontSize(11);
	firstEdit->SetDivider(75);
	regView->AddChild( firstEdit );

	temp = _("label152");
	temp += ":";
	lastEdit = new BTextControl(BRect(7, 60, bounds.right - 7, 80), "last", temp.String(), "", 0);
	lastEdit->TextView()->SetMaxBytes(20);
	lastEdit->SetFont(be_bold_font);
	lastEdit->SetFontSize(11);
	lastEdit->SetDivider(75);
	regView->AddChild( lastEdit );
	
	temp = _("label153");
	temp += ":";
	emailEdit = new BTextControl(BRect(7, 85, bounds.right - 7, 105), "email", temp.String() , "", 0);
	emailEdit->TextView()->SetMaxBytes(30);
	emailEdit->SetFont(be_bold_font);
	emailEdit->SetFontSize(11);
	emailEdit->SetDivider(75);
	regView->AddChild( emailEdit );
	
	temp = _("label154");
	temp += ":";
	BMenu* fieldMenu = new BPopUpMenu( "Yes" );
	yesNo = new BMessage(YESNO_MSG);
	yesNo->AddBool( "auth", true );
	fieldMenu->AddItem( yesItem = new BMenuItem(_("menuitem140") , yesNo) );
	yesNo = new BMessage(YESNO_MSG);
	yesNo->AddBool( "auth", false );
	fieldMenu->AddItem( noItem = new BMenuItem(_("menuitem141") , yesNo) );
	authRequired = new BMenuField( BRect(7, 110, bounds.right - 7, 120), "st", temp.String(), fieldMenu );
	authRequired->SetFont(be_bold_font);
	authRequired->SetFontSize(11);
	authRequired->SetDivider(142);	
	regView->AddChild( authRequired );
	

	temp = _("label155");
	temp += ":";
	ageEdit = new BTextControl(BRect(7, 10, (bounds.right-14)/2-30, 30), "last", temp.String(), "", 0);
	ageEdit->TextView()->SetMaxBytes(3);
	ageEdit->SetFont(be_bold_font);
	ageEdit->SetFontSize(11);
	ageEdit->SetDivider(30);
	extView->AddChild( ageEdit );

	temp = _("label156");
	temp += ":";
	BMenu* fieldMenu3 = new BPopUpMenu( "Sex" );
	sexMsg = new BMessage(SEX_MSG);
	sexMsg->AddInt32( "sex", ICQ_SEX_MALE );
	fieldMenu3->AddItem( maleItem = new BMenuItem(_("menuitem150") , sexMsg) );
	sexMsg = new BMessage(SEX_MSG);
	sexMsg->AddInt32( "sex", ICQ_SEX_FEMALE );
	fieldMenu3->AddItem( femaleItem = new BMenuItem(_("menuitem151") , sexMsg) );
	sexMsg = new BMessage(SEX_MSG);
	sexMsg->AddInt32( "sex", ICQ_SEX_UNKNOWN );
	fieldMenu3->AddItem( unknownItem = new BMenuItem(_("menuitem152") , sexMsg) );
	sexMsg = new BMessage(SEX_MSG);
	sexMsg->AddInt32( "sex", ICQ_SEX_UNKNOWN );
	BMenuItem* zzTemp = new BMenuItem(_("menuitem153") , sexMsg);
	zzTemp->SetEnabled(false);
	if( modifiers() & B_COMMAND_KEY )
		fieldMenu3->AddItem( zzTemp );
	sexEdit = new BMenuField( BRect(ageEdit->Bounds().right+25, 10, bounds.right - 7, 30 ), "st", temp.String(), fieldMenu3 );
	sexEdit->SetFont(be_bold_font);
	sexEdit->SetFontSize(11);
	sexEdit->SetDivider(50);
	extView->AddChild( sexEdit );

	temp = _("label157");
	temp += ":";
	cityEdit = new BTextControl(BRect(7, 35, (bounds.right-14)/2-30, 55), "city", temp.String(), "", 0);
	cityEdit->TextView()->SetMaxBytes(50);
	cityEdit->SetFont(be_bold_font);
	cityEdit->SetFontSize(11);
	cityEdit->SetDivider(30);
	extView->AddChild( cityEdit );

	temp = _("label158");
	temp += ":";
	stateEdit = new BTextControl(	BRect(cityEdit->Bounds().right+25, 35, cityEdit->Bounds().right+75, 55), "state",
																temp.String(), "", 0);
	stateEdit->SetFont(be_bold_font);
	stateEdit->SetFontSize(11);
	stateEdit->SetDivider(20);
	stateEdit->TextView()->SetMaxBytes(2);
	extView->AddChild( stateEdit );

	temp = _("label159");
	temp += ":";
	zipEdit = new BTextControl(BRect(200, 35, bounds.right - 7, 55 ), "zip", temp.String(), "", 0);
	zipEdit->TextView()->SetMaxBytes(5);
	zipEdit->SetFont(be_bold_font);
	zipEdit->SetFontSize(11);
	zipEdit->SetDivider(25);
	extView->AddChild( zipEdit );

	// 10, 30
	// 35, 55
	// 60, 80
	
	BMenu* fieldMenu2 = new BPopUpMenu( "Yes" );
	CountryMenuItem* temp42;
	for( int i = 0; i<Country_table_size; i++ ) {
		countriesMsg = new BMessage(COUNTRY_MSG);
		countriesMsg->AddInt16( "countrycode", Country_table[i].code );
		temp42 = new CountryMenuItem( Country_table[i].code, Country_table[i].name, countriesMsg );
		countryItems.AddItem( temp42 );
		fieldMenu2->AddItem( temp42 );
	}

	temp = _("label160");
	temp += ":";
	countryEdit = new BMenuField( BRect(7, 60, bounds.right - 7, 80), "st", temp.String() , fieldMenu2 );
	countryEdit->SetFont(be_bold_font);
	countryEdit->SetFontSize(11);
	countryEdit->SetDivider(75);	
	extView->AddChild( countryEdit );
	
	temp = _("label161");
	temp += ":";
	webEdit = new BTextControl(BRect(7, 85, bounds.right - 7, 105), "home", temp.String(), "", 0);
	webEdit->SetFont(be_bold_font);
	webEdit->SetFontSize(11);
	webEdit->SetDivider(75);
	extView->AddChild( webEdit );
	
	temp = _("label162");
	temp += ":";
	phoneEdit = new BTextControl(BRect(7, 110, bounds.right - 7, 120), "phone", temp.String(), "", 0);
	phoneEdit->SetFont(be_bold_font);
	phoneEdit->SetFontSize(11);
	phoneEdit->SetDivider(75);
	extView->AddChild( phoneEdit );
	
	// make the notes editor/label
	BStringView* notesLabel;
	BFont chatFont = be_plain_font;
	chatFont.SetSize( 12.0 );
	BRect txbounds = profView->Bounds();
	txbounds.InsetBy(8,6);
	txbounds.top += 16;
	txbounds.bottom -= 5;
	txbounds.right -= B_V_SCROLL_BAR_WIDTH;
	BRect txrect = txbounds;
	txrect.OffsetTo(0,0);
	txrect.InsetBy(4,4);
	profile = new BTextView( txbounds, "notes", txrect, B_FOLLOW_NONE, B_PULSE_NEEDED | B_WILL_DRAW );
	profile->SetFontAndColor( &chatFont );
	profile->SetMaxBytes( 254 );

	temp = _("label163");
	temp += ":";
	notesLabel = new BStringView( BRect(8,0,300,20), "label2", temp.String() );
	notesLabel->SetFontSize(12);
	profView->AddChild( notesLabel );
	profView->AddChild(profilescroller = new BScrollView("notes_scroll_view", profile,
						B_FOLLOW_NONE, 0, false, true ));

	// make some buttons
	BRect a_rect;
	a_rect = windowBack -> Bounds();
	a_rect.right -= 5;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 10;
	a_rect.top = a_rect.bottom - 20;
	cancelButton = new GButton( a_rect, "cancel", _("cancelbutton") , new BMessage(B_CANCEL) );

	a_rect.right -= cancelButton -> Bounds().Width() + 7;
	a_rect.left = a_rect.right - 80;
	updateButton = new GButton( a_rect, "update", _("button5"), new BMessage((unsigned long)B_OK) );
	updateButton->MakeDefault(true);
	windowBack->AddChild(updateButton);
	windowBack->AddChild(cancelButton);
	
	tabView->Select( 0 );
	nickEdit->MakeFocus(true);
	Load();
}

//---------------------------------------------------------

void UpdateInfoWindow::MessageReceived( BMessage *msg )
{
	switch( msg->what )
	{
		case B_OK:
			Save();
			
		case B_CANCEL:
			PostMessage( new BMessage(B_QUIT_REQUESTED) );
			break;
			
		case YESNO_MSG:
			auth = msg->FindBool("auth");
			break;
			
		case COUNTRY_MSG:
			country = (unsigned short)msg->FindInt32("countrycode");
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

//---------------------------------------------------------

bool UpdateInfoWindow::QuitRequested()
{
	mManager -> windows -> CloseGeneralWindow(this);

	return(true);
}

//---------------------------------------------------------

void UpdateInfoWindow::Save() {

	int32 sex = ICQ_SEX_UNKNOWN;

	// nick/whatever stuff
#if 0
	mManager -> prefs->WriteString( "nick", nickEdit->Text() );
	mManager -> prefs->WriteString( "first", firstEdit->Text() );
	mManager -> prefs->WriteString( "last", lastEdit->Text() );
	mManager -> prefs->WriteString( "email", emailEdit->Text() );
	mManager -> prefs->WriteString( "homepage", webEdit->Text() );
	mManager -> prefs->WriteString( "phone", phoneEdit->Text() );
	mManager -> prefs->WriteString( "city", cityEdit->Text() );
	mManager -> prefs->WriteString( "state", stateEdit->Text() );
	mManager -> prefs->WriteInt32( "age", atoi(ageEdit->Text()) );
	mManager -> prefs->WriteInt32( "zip", atoi(zipEdit->Text()) );
	mManager -> prefs->WriteString( "profile", profile->Text() );
#endif

	// auth stuff
	if( yesItem->IsMarked() )
		mManager -> prefs->WriteBool( "auth", true );
	else
		mManager -> prefs->WriteBool( "auth", false );
		
	// sex stuff
	if( maleItem->IsMarked() )
		sex = ICQ_SEX_MALE;
	else if( femaleItem->IsMarked() )
		sex = ICQ_SEX_FEMALE;
	else if( unknownItem->IsMarked() )
		sex = ICQ_SEX_UNKNOWN;
	mManager -> prefs->WriteInt32( "sex", sex );
	
	// country stuff
	mManager -> prefs->WriteInt32( "country", country );

	// send the ICQ update messages
	BMessage* m = new BMessage( ICQ_UPDATE_INFO );
	m->AddString( "EMAIL", emailEdit->Text() );
	m->AddString( "FIRSTNAME", firstEdit->Text() );
	m->AddString( "LASTNAME", lastEdit->Text() );
	m->AddString( "NICKNAME", nickEdit->Text() );
	m->AddBool( "AUTHORIZE", yesItem->IsMarked() );
	mManager -> icq->PostMessage( m );
	m->what = ICQ_CLIENT_INFO;
	//PostAppMessage( m );
	
	// send the ICQ update messages
	m = new BMessage( ICQ_UPDATE_EXTINFO );
	m->AddString( "CITY", cityEdit->Text() );
	m->AddString( "STATE", stateEdit->Text() );
	m->AddString( "HOMEPAGE", webEdit->Text() );
	m->AddString( "PHONENUMBER", phoneEdit->Text() );
	m->AddString( "PROFILE", profile->Text() );
	m->AddInt32( "AGE", (int32)atoi(ageEdit->Text()) );
	m->AddInt32( "SEX", sex );
	m->AddInt32( "COUNTRY", country );
	m->AddInt32( "TIMEZONE", timezone_hours() );
	m->AddInt32( "ZIPCODE", (int32)atoi(zipEdit->Text()) );
	mManager -> icq->PostMessage( m );
}

//---------------------------------------------------------

void UpdateInfoWindow::Load() {

	char nickName[500];
	char lastName[500];
	char firstName[500];
	char email[500];
	char homepage[500];
	char profile2[255];
	char phone[500];
	char city[500];
	char state[10];

	int32 age(0);
	int32 zip(0);

	auth = mManager -> prefs->ReadBool( "auth", false );
	if( auth )
		yesItem->SetMarked(true);
	else
		noItem->SetMarked(true);
		
	int32 sex = mManager -> prefs->ReadInt32( "sex", ICQ_SEX_UNKNOWN );
	switch( sex ) {
		case ICQ_SEX_MALE:
			maleItem->SetMarked(true);
			break;
		case ICQ_SEX_FEMALE:
			femaleItem->SetMarked(true);
			break;
		case ICQ_SEX_UNKNOWN:
		default:
			unknownItem->SetMarked(true);
			break;
	}
	
	country = mManager -> prefs->ReadInt32( "country", 1 );
	CountryMenuItem *item = countryItems.FindItem( global_code_find, &country );
	item->SetMarked(true);

#if 0
	mManager -> prefs->ReadString( "nick", nickName, "", 500 );
	mManager -> prefs->ReadString( "first", firstName, "", 500 );
	mManager -> prefs->ReadString( "last", lastName, "", 500 );
	mManager -> prefs->ReadString( "email", email, "", 500 );
	mManager -> prefs->ReadString( "homepage", homepage, "", 500 );
	mManager -> prefs->ReadString( "phone", phone, "", 500 );
	mManager -> prefs->ReadString( "city", city, "", 500 );
	mManager -> prefs->ReadString( "state", state, "", 10 );
	mManager -> prefs->ReadString( "profile", profile2, "", 255 );
	age = mManager -> prefs->ReadInt32( "age", 0 );
	zip = mManager -> prefs->ReadInt32( "zip", 0 );
#endif

	BString temp;
	temp << age;
	ageEdit->SetText( temp.String() );
	temp = "";
	temp << zip;
	zipEdit->SetText( temp.String() );

	nickEdit->SetText( nickName );
	firstEdit->SetText( firstName );
	lastEdit->SetText( lastName );
	emailEdit->SetText( email );
	webEdit->SetText( homepage );
	phoneEdit->SetText( phone );
	cityEdit->SetText( city );
	stateEdit->SetText( state );
	profile->SetText( profile2, strlen(profile2) );
}

//---------------------------------------------------------

// the cancel function
void UpdateInfoWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

//---------------------------------------------------------
