#ifndef __KDeskbar_h__
#define __KDeskbar_h__

class BView;
class BMessenger;

class KDeskbar
{
  public:
	static KDeskbar* Instance();

	status_t AddReplicant(const BView* view, bool force = false);
	status_t RemoveReplicant(const char* name);
	int32 CountReplicant(const char* name = NULL);
	status_t TalkToReplicant( BMessage* );

	status_t Activate();
	BRect Frame();
	bool IsLocal() const {return mIsLocal;}

	status_t SetTimeout(bigtime_t timeout);
	bigtime_t Timeout() const {return mTimeout;}

  private:
	KDeskbar();
	KDeskbar(const KDeskbar&);
	KDeskbar& operator=(const KDeskbar&);

	BMessenger Shelf();

	static KDeskbar* sInstance;

	bool mIsLocal;
	bigtime_t mTimeout;
};

#endif
