#include <Debug.h>
#include "NewUser.h"

#include <String.h>
#include <View.h>
#include <StringView.h>
#include <Box.h>

#include "GButton.h"
#include "Say.h"
#include "PassControl.h"
#include "BarberPole.h"
#include "GManager.h"
#include "Gicq.h"
#include "WindowManager.h"
#include "Prefs.h"
#include "Locale.h"

NewUserBox::NewUserBox( BRect frame, GManager *the_manager )
						: BWindow( frame, "New User", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	PRINT(("NewUserBox::NewUserBox\n"));
	mManager = the_manager;
	mLocale = mManager -> mLocale;	
	BString temp;
	
	windowBack = new BView( Bounds(), "windowBack", B_FOLLOW_ALL_SIDES, B_WILL_DRAW );
	windowBack -> SetViewColor( 216, 216, 216 );
	AddChild( windowBack );
	BRect bounds = windowBack->Bounds();
	
	temp = _("label50");
	temp += ":";
	sv = new BStringView( BRect(8,5,300,25), "label2", temp.String() );
	sv->SetFont( be_plain_font );
	sv->SetFontSize(12);
	windowBack->AddChild( sv );

	temp = _("label51");
	temp += ":";
	Password1 = new PassControl(BRect(7, 30, bounds.right - 7, 50), "nick", temp.String() , "", 0);
	Password1->TextView()->SetMaxBytes(20);
	Password1->SetFont(be_bold_font);
	Password1->SetFontSize(11);
	Password1->SetDivider(90);
	windowBack->AddChild( Password1 );
	
	temp = _("label52");
	temp += ":";
	Password2 = new PassControl(BRect(7, 55, bounds.right - 7, 75), "first", temp.String() , "", 0);
	Password2->TextView()->SetMaxBytes(20);
	Password2->SetFont(be_bold_font);
	Password2->SetFontSize(11);
	Password2->SetDivider(90);
	windowBack->AddChild( Password2 );

	SaveButton = new GButton( BRect( bounds.right-125, bounds.bottom-30, bounds.right-70, bounds.bottom-10 ), "save", "OK", new BMessage((unsigned long)B_OK) );
	SaveButton->SetTarget(this);
	SaveButton->MakeDefault(true);
	windowBack->AddChild( SaveButton );

	CancelButton = new GButton( BRect( bounds.right-60, bounds.bottom-30, bounds.right-5, bounds.bottom-10 ), "save", "Cancel", new BMessage(B_CANCEL) );
	CancelButton->SetTarget(this); 
	windowBack->AddChild( CancelButton );

	DoneButton = new GButton( BRect( bounds.right-60, bounds.bottom-30, bounds.right-5, bounds.bottom-10 ), "save", "Close", new BMessage(B_CANCEL) );
	DoneButton->SetEnabled(false);	
	DoneButton->SetTarget(this); 
	DoneButton->Hide();
	windowBack->AddChild( DoneButton );

	spinner = new BarberPole( BRect(7,bounds.bottom-13,100,bounds.bottom-7), "spinner", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW );
	spinner->SetHighColor(0,128,0);
	spinner->Hide();
	windowBack->AddChild( spinner );
	
	temp = _("label53");
	temp += B_UTF8_ELLIPSIS;
	spinStatus = new BStringView( BRect(6,bounds.bottom-25,300,bounds.bottom-15), "label2", temp.String() );
	spinStatus->SetFont( be_plain_font );
	spinStatus->Hide();
	windowBack->AddChild( spinStatus );

	BBox* divider = new BBox(BRect(11,85,bounds.right-11,87),"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	windowBack->AddChild( divider );
	Password1->MakeFocus(true);

	var = 0;
}


void NewUserBox::MessageReceived( BMessage *msg )
{
	PRINT(("NewUserBox::MessageReceived\n"));
	switch( msg->what )
	{

		case B_OK:
			Start();
			break;

		case B_CANCEL:
			PostMessage( new BMessage(B_QUIT_REQUESTED) );
			break;
			
		case ICQ_NEW_UIN:
			Doneski();
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	};
}

bool NewUserBox::QuitRequested()
{

	PRINT(("NewUserBox::QuitRequested\n"));
	mManager -> windows -> CloseGeneralWindow(this);

//	mManager -> icq->PostMessage( new BMessage(ST_DISCONNECT) );

	if( spinner ) {
		spinner->Stop();
		spinner->RemoveSelf();
		delete spinner;
	}
	if(mManager -> windows != NULL)
		mManager -> windows->SetNewUserBoxClose();
	return(true);
}


// the cancel function
void NewUserBox::DispatchMessage( BMessage* msg, BHandler* handler ) {

	PRINT(("NewUserBox::DispatchMessage\n"));
	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}


void NewUserBox::Start() {

	PRINT(("NewUserBox::Start\n"));
	// Host and port
	char icq_host[255];
	int32 icq_port = 0;	

	if( strcmp( Password1->actualText(), Password2->actualText() ) != 0 ) {
		Say( _("text120") );
		Password1->MakeFocus(true);
		return;
	}

	var = 1;
	Password1->SetEnabled(false);
	Password2->SetEnabled(false);
	SaveButton->Hide();
	CancelButton->Hide();
	while( DoneButton->IsHidden() )
		DoneButton->Show();
	while( spinner->IsHidden() )
		spinner->Show();
	spinner->Start();
	while( spinStatus->IsHidden() )
		spinStatus->Show();

	// read the host/port prefs
	mManager -> prefs->ReadString( "icq_host", icq_host, "icq.mirabilis.com", 255, true );
	icq_port = mManager -> prefs->ReadInt32( "icq_port", 4000, true );

	// send the connect message
#warning NewUser window is broken.
#if 0
	if( mManager -> icq -> Connect( icq_host , icq_port ) > 0 ) {
		BMessage* msg = new BMessage(ICQ_NEW_UIN);
		msg->AddString( "PASSWORD", Password1->actualText() );
		mManager -> icq -> PostMessage(msg);
	}
#endif	
}


void NewUserBox::Doneski() {

	PRINT(("NewUserBox::Doneski\n"));
	if( spinner ) {
		spinner->Stop();
		spinner->RemoveSelf();
		delete spinner;
	}
}
