#ifndef HISTORYIO_H
#define HISTORYIO_H

#include <Looper.h>
#include <String.h>

class BMessage;
class BFile;
class BLocker;
class BWindow;

class GManager;

enum chatType {
	CT_OUTGOING_MESSAGE,
	CT_INCOMING_MESSAGE,
	CT_OUTGOING_URL,
	CT_INCOMING_URL,
	CT_OFFLINE_DONE
};

/* This struct makes it a faster Add function, but
 * slower First and Next function. The Add function
 * is mostly used and First, Next is not critical in
 * time.
 */ 


/* File Format
	
	Message:
	
	"::"          - length == 1;
	"time"        - length == sizeof(time_t);
	"type"        - length == sizeof(int32);
	"size"        - length == sizeof(int32);  // the size of the message below
	"message"     - length == sizeof(size);

	Url:
	"::"          - length == 1;
	"time"        - length == sizeof(time_t);
	"type"        - length == sizeof(int32);
	"size_url"    - length == sizeof(int32);  // the size of the url below
	"url"         - length == sizeof(size_url);
	"size"        - length == sizeof(int32);  // the size of the message below
	"message"     - length == sizeof(size);
	
*/

struct chatEntry {

	BString message;
	BString url;

	time_t time;
	chatType type;
	uint32 uin;
	uint32 own_uin;
};


class HistoryIO: public BLooper {

public:
	HistoryIO(GManager *the_manager);
	~HistoryIO();
	
	void ReadAll(const uint32 uin, const uint32 own_uin, BWindow *history_window);
#if 0
	void ReWrite(GenList<chatEntry> list, const uint32 uin, const uint32 own_uin);
#endif
	
	virtual void MessageReceived(BMessage *message);

private:
	
	void Write(const chatEntry entry);
	bool findNextMessage(BFile *the_file);	
	
	BLocker *the_lock;

	GManager *mManager;
	
};


#endif

