#ifndef _PEOPLE_DATA_H_
#define _PEOPLE_DATA_H_

#include <String.h>
#include <ListItem.h>
#include <StorageDefs.h>

#include "ICQStatus.h"
#include "GConstants.h"

class BView;
class BRect;
class BOutLineListView;
class BLocker;

class GManager;
class Locale;
template<class T> class PList;

//=========================================================================

class GroupItem : public BListItem
{ 
public: 
	GroupItem( const char *aType );
	~GroupItem(); 
	virtual void DrawItem( BView *owner, BRect frame, bool complete = false ); 

private: 
	BString mType;

};

//=========================================================================

class PeopleItem : public BListItem
{ 
public: 
	PeopleItem( uint32 aUin, const char *aNick, ICQStatus aStatus, uint32 aEncoding, bool aOnlineNotify, GManager *aManager );
	~PeopleItem(); 
	virtual void DrawItem( BView *owner, BRect frame, bool complete = false ); 
	const char *GetDisplayName();
	uint32 GetUIN();
	uint32 GetEncoding();
	void SetEncoding(uint32);
	void SetStatus( ICQStatus );
	ICQStatus GetStatus();
	void SetNick( const char *s );
	bool GetOnlineNotify();
	void SetOnlineNotify( bool aOnlineNotify );
	void SetGotNewMessage( bool );

private: 
	volatile uint32 mUin;
	BString mNick;
	BString mStrUin;
	volatile ICQStatus mStatus;
	volatile uint32 mEncoding;
	volatile bool mOnlineNotify;
	volatile bool mUnreadMsg;

	BLocker *mLock;
	GManager *mManager;
};

//=========================================================================

typedef struct {
	PeopleItem* item;
	uint32 uin;
} PersonInfo;

//=========================================================================

class PeopleList {

public:
	PeopleList(GManager *aManager);
	~PeopleList();
	void SetDisplayList( BOutlineListView *aDisplay );
	
	const char *FindNameForUIN( uint32 aUin );
	bool FindEncodingForUIN( uint32 aUin, uint32& aEncoding );
	
	PersonInfo* AddPerson( uint32 aUin, const char* aNick, ICQStatus aStatus, uint32 aEncoding, bool aOnlineNotify=false, bool commitnow=true, bool check=true );
	void RemovePerson( uint32 aUin, bool commitnow=true );
	bool HasPerson( uint32 aUin );

	void SetPersonStatus( uint32 aUin, ICQStatus aStatus );
	void SetPersonNick( uint32 aUin, const char* aNick );
	void SetPersonEncoding( uint32 aUin, uint32 aEncoding );
	void SetPersonNotify( uint32 aUin, bool aOnlineNotify );
	void SetPersonMessage( uint32 aUin, bool aUnreadMsg );

	void SetProgramUser( uint32 aUin );

	void Attach( PersonInfo* );
	void Reset();

	void Debug();

private:

	void RemovePerson( PersonInfo*, bool commitnow=false );
	void SetPersonStatus( PersonInfo*, ICQStatus aStatus );
	void SetPersonNick( PersonInfo*, const char* aNick );
	void SetPersonEncoding( PersonInfo*, uint32 aEncoding );
	void SetPersonNotify( PersonInfo*, bool aOnlineNotify );
	void SetPersonMessage( PersonInfo*, bool aUnreadMsg );

	void Load();
	void Save();

	uint32 mUin;		//The applications user's UIN.

	BOutlineListView* mDisplay;
	PList<PersonInfo> *mPersonList;
		
	char mFilename[ B_PATH_NAME_LENGTH ];
	BLocker *mLock;

	GroupItem* mOnlineGroup;
	GroupItem* mOfflineGroup;

	GManager *mManager;
};


#endif
