#ifndef _GPREFS_H_
#define _GPREFS_H_

#include "GConstants.h"

class BRect;
class BPoint;
class BLocker;
class BFile;
class BDirectory;

class GPreferences {

public:
	GPreferences();
	~GPreferences();
	
	void LoadUserFile( uint32 aUin, bool create = true );
	void GetUserLoginParameters( uint32 aUin, char *aPassword, int aLen, bool &autoLogin, bool &savePassword );
	
	// read/write functions
	void WriteBool( const char *aName, bool aValue, bool global=false );
	bool ReadBool( const char *aName, bool aDefault, bool global=false );
	
	void WriteString( const char *aName, const char *aValue, bool global=false );
	void ReadString( const char *aName, char *aBuf, const char *aDefault, uint32 aSize, bool global=false );
	
	void WriteInt32( const char *aName, int32 aValue, bool global=false );
	int32 ReadInt32( const char *aName, int32 aDefault, bool global=false );
	
	void WriteFloat( const char *aName, float aValue, bool global=false );
	float ReadFloat( const char *aName, float aDefault, bool global=false );
	
	void WriteRect( const char *aName, BRect aValue, bool global=false );
	BRect ReadRect( const char *aName, BRect aDefault, bool global=false );
	
	void WritePoint( const char *aName, BPoint aValue, bool global=false );
	BPoint ReadPoint( const char *aName, BPoint aDefault, bool global=false );
	
	bool GetNextUser( uint32 &aUin, bool first = false );

	//Functions to find and create pref dirs, and pref files.
	status_t FindConfigDir( const char *aRelativeDir, BDirectory *aDirectory );
	status_t FindConfigFile( const char *aRelativeDir, const char *aFilename, BFile *aFile, uint32 openMode, BPath *aPath=NULL );
	BPath SettingDir();
	
private:

	void LoadDefaultUser();

	uint32 mUin;					//The Users UIN.
	BLocker *mLock;
	BFile *mPrefsFile;
	BFile *mGlobalPrefsFile;
	BDirectory *mPrefsDirectory;

};

#endif
