#ifndef _WINDOW_MANAGER_H_
#define _WINDOW_MANAGER_H_

#include <Rect.h>
#include <UTF8.h>

class BWindow;
class BView;
class BMessage;
class BLocker;
class BPoint;

class GManager;
class	BuddyList;
class BuddyWindow;
class	LoginWindow;
class	SearchResultsWindow;
class	AboutBox;
template<class T> class PList;

// Used to define the list of open IM windows
struct IMWindowItem {
	IMWindowItem( uint32 u=0, int tp=0, BWindow *w=NULL )
		:uin(u),type(tp),window(w){}
	
	uint32 uin;
	int type;
	BWindow *window;

};


// holds window positions
struct WinPos {
	uint32 uin;
	BRect rect;
};

// WindowManager - the class that handles the opening and closing of various
//   Gim-ICQ windows, like the IM Windows and info windows and stuff.
class WindowManager {

public:
	WindowManager(GManager *aManager);
	~WindowManager();

	void OpenBuddyList( BPoint *point = NULL );
	void CloseBuddyList();
	BuddyList *getBuddyList() { return bList; }
	void setBuddyList(BuddyList *the_bList){bList = the_bList;}

	void OpenPrefsWindow( bool globalOnly = false, BPoint *point = NULL );

	void OpenSignOnWindow( BPoint *point = NULL );
	void SignOnStop();
	void CloseSignOnWindow(bool should_quit = true);
	
	BWindow *OpenUserWindow( BMessage *aMsg);
	void UserWindowOpened( BMessage *aMsg );
	void UserWindowClosed( BMessage *aMsg );
	void SwitchUserWindow( BMessage *aMsg );
	void ForwardIncomingMessage( BMessage *aMsg, bool should_open = true );
	void BroadcastMessage( BMessage *aMsg, bool toApp = true );
	
	void ForwardEmailSearchResults( BMessage *aMsg );
	void OpenEmailSearchResultsWindow( BMessage *aMsg );
	void EmailSearchResultsWindowClosed();
	
	void SendBuddyListMessage( BMessage *aMsg );
	void SendSignOnMessage( BMessage *aMsg );
	void SetProgramUser( uint32 aUin );
	
	void MakeDialogFrame( BRect&, BPoint );
	void MakeDialogFrame( BRect&, BWindow *);
	void MakeDialogFrame( BRect&, BView *);
	void AdjustFrame( BRect& );
	void CenterFrame( BRect& );
	
	void ToggleHidden();
	
	void DoAbout();

	bool FindWindowPosition( uint32 aUin, BRect& aRect );
	void SetWindowPosition( uint32 aUin, BRect aRect );

	void AddGeneralWindow(BWindow *w);
	void CloseGeneralWindow(BWindow *w, bool should_quit = false);
	void CloseAllGeneralWindows();
	void CloseAllIMWindows();


private:

	void LoadWindowPositions();
	void SaveWindowPositions();

	void CalcNewIMRect();
	BWindow *MakeMessageWindow( uint32 aUin, const char *nick = NULL, bool min = false, uint32 encoding = B_MS_WINDOWS_CONVERSION );
	BWindow *MakeInfoWindow( uint32 aUin, const char *nick = NULL, BWindow *posWindow = NULL );

	BRect mIMWindowRect;
	PList<IMWindowItem> *mIMWindows;
	PList<WinPos> *mWinPositions;
	PList<BWindow> *mGeneralWindows;

	BuddyList *bList;
	LoginWindow *signOn;
	SearchResultsWindow *resWin;
	AboutBox *about;
	BLocker *mLock;
	uint32 mUin;
	
	volatile bool closing_all_general;

	GManager *mManager;

};

#endif
