#ifndef INFO_WINDOW_H
#define INFO_WINDOW_H

#include <Window.h>
#include <View.h>
#include <TextView.h>
#include <String.h>

#include "GConstants.h"

//=========================================================================

class BRect;
class BPoint;
class BMeessage;
class BStringView;
class BScrollView;
class	BarberPole;
class BHandler;
		
class GButton;
class GManager;
class Locale;
class FancyTextView;

class GStatusView : public BView 
{
	friend class InfoWindow;

	public:
		GStatusView(BRect frame, GManager *the_manager);
		virtual void Draw( BRect );
		virtual void MouseDown( BPoint cursor );
		void SetDone1();
		void SetDone2();
		bool AllDone() { return bool(done1 && done2); };
		
	private:
		BString showString;
		bool done1;
		bool done2;
		
		Locale *mLocale;
		
};

//=========================================================================

class InfoTextView : public BTextView {

	public:
		InfoTextView( BRect, const char*, BRect, uint32 = B_FOLLOW_NONE, uint32 = B_WILL_DRAW | B_PULSE_NEEDED );
		virtual void InsertText(const char *text, int32 length, int32 offset, const text_run_array *runs );
		virtual void DeleteText(int32 start, int32 finish);
		bool WasModified() { return modified; };
		void SetText2( char* text );
		
	private:
		bool modified;
};

//-------------------------------------------------------------------------

class InfoView : public BView 
{
	friend class InfoWindow;

	public:
		InfoView( BRect frame, const char *name, unsigned uin , GManager *mManager );
		void AttachedToWindow();
		void UpdateDisplay( BMessage* );
		void UpdateDisplay2( BMessage* );
		
	private:
	
		void FixLineBreaks( char* buffer, char* input );
	
		GButton* closeButton;
		GButton* addToListButton;
		GButton* notesButton;
		
		BStringView *label1, *label2;
		BStringView *label3, *label4;
		BStringView *label5, *label6;
		BStringView *label7, *label8;
		BStringView *label9, *label10;
		BStringView *label11, *label12;
		
		BStringView *Label1, *Label2;
		BStringView *Label3, *Label4;
		BStringView *Label5, *Label6;
		BStringView *Label7, *Label8;
		BStringView *Label9, *Label10;
		BStringView *Label11, *Label12;	
		BStringView *Label13, *Label14;	
		
		FancyTextView* profile;
		BScrollView* profHolder;

		BarberPole* spinner;
		unsigned uin;
		BMessage* updateMsg;
		bool shouldUpdate;
		BTextView* notes;
		BScrollView* notes_scroller;
		GStatusView* statView;		

		GManager *mManager;
		Locale *mLocale;
};

//-------------------------------------------------------------------------

class InfoWindow : public BWindow 
{
	friend class InfoView;

	public:
		InfoWindow( BRect frame, unsigned u, const char* nick, GManager *the_manager );
		virtual	bool QuitRequested();
		virtual void MessageReceived( BMessage* );
		virtual void DispatchMessage( BMessage* msg, BHandler* handler );
				
	private:

		void AddPerson();

		InfoView* iView;
		BString displayName;
		unsigned int uin;
		bool alldone;
		GManager *mManager;
};

//-------------------------------------------------------------------------

#endif //HELLO_WINDOW_H
