#include <Debug.h>
#include "ResultsWindow.h"

#include <StringView.h>
#include <ScrollView.h>
#include <PopUpMenu.h>
#include <MenuItem.h>

#include <stdlib.h>

#include "GButton.h"
#include "BarberPole.h"
#include "BetterScrollView.h"
#include "GManager.h"
#include "WindowManager.h"
#include "Gicq.h"
#include "Locale.h"

//-------------------------------------------------------------------------

SearchResultsWindow::SearchResultsWindow( BRect frame, GManager *the_manager )
				: BWindow(frame, the_manager -> _("title6"), B_DOCUMENT_WINDOW_LOOK, 
				  B_NORMAL_WINDOW_FEEL, B_NOT_ZOOMABLE )
{

	mManager = the_manager;
	mLocale = mManager -> mLocale;
		
	BRect frame2, framer = Bounds();
	framer.bottom -= 14;
	float minW, maxW, minH, maxH;
	
	// size limits stuff
	GetSizeLimits( &minW, &maxW, &minH, &maxH );
	SetSizeLimits( 265, maxW, 125, maxH );

	// create and add the results view
	resView = new ResultsView( framer, "ResultsView", mManager );
	AddChild(resView);
	empty = true;
	
	// create and add the status view
	frame2 = Bounds();
	frame2.top = framer.bottom + 1;
	statView = new StatusView( frame2, mManager );
	
	// make the spinner
	spinner = new BarberPole( BRect(4,4,50,10), "spinner", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW );
	spinner->SetHighColor(0,128,0);
	statView->AddChild( spinner );
	AddChild(statView);
	spinner->Start();
	
	SetPulseRate( 1000000 );
}

//-------------------------------------------------------------------------

bool SearchResultsWindow::QuitRequested()
{

	mManager -> windows -> CloseGeneralWindow(this);
	// get rid of the spinner
	if( spinner ) {
		spinner->Stop();
		statView->RemoveChild(spinner);
		delete spinner;
		spinner = 0;
	}
	if(mManager -> windows != NULL)
		mManager -> windows -> SendBuddyListMessage( new BMessage(GIMICQ_ESEARCH_RESULTS_CLOSED) );
	return(true);
}

//-------------------------------------------------------------------------

void SearchResultsWindow::MessageReceived( BMessage* msg ) {

	switch( msg->what ) {

		case B_CANCEL:
		case GIMICQ_CLOSE_WINDOW:
			QuitRequested();
			Close();
			break;
			
		// this is a new search
		case GIMICQ_OPEN_EMAIL_SEARCH:
			SetupNewSearch( msg );
			break;
			
		// incoming search results
		case ICQ_USER_SEARCH:
			ParseIncomingResults( msg );
			break;
			
		// search is done
		case ICQ_USER_SEARCH_EXPIRED:
			statView->SetDone( false );
			break;
			
		case ICQ_USER_SEARCH_DONE:
		// get rid of the spinner
			if( spinner ) {
				spinner->Stop();
				statView->RemoveChild(spinner);
				delete spinner;
				spinner = 0;
			}		
			statView->SetDone( msg->FindBool("MORE") );
			break;			
			
		case ENABLE_CONTEXT_BUTTONS: {
			bool enabled = msg->FindBool("enabled");
			resView->addToListButton->SetEnabled(enabled);
			resView->infoButton->SetEnabled(enabled);
			break;
		}
		
		case GIMICQ_GET_PERSON_INFO: {
			int32 CL = resView->lview->CurrentSelection();
			BListItem* curItem = resView->lview->ItemAt(CL);
			CLVEasyItem* ezItem = dynamic_cast<CLVEasyItem*>(curItem);
			if( ezItem ) {
				unsigned uin = atol(ezItem->GetColumnContentText(0));
				BMessage* sendMessage;
				sendMessage = new BMessage(GIMICQ_OPEN_USER_WINDOW);
				sendMessage->AddInt32( "UIN", (int32)uin );	
				if( ezItem->GetColumnContentText(1) )
					sendMessage->AddString( "nick", ezItem->GetColumnContentText(1) );
				sendMessage->AddInt32( "wtype", (int32)USER_INFO_TYPE );
				sendMessage->AddPointer( "poswindow", this );
				mManager -> windows -> SendBuddyListMessage( sendMessage );				
			}
			break;
		}
			
		case GIMICQ_TRY_ADD_PERSON: {
			int32 CL = resView->lview->CurrentSelection();
			BListItem* curItem = resView->lview->ItemAt(CL);
			CLVEasyItem* ezItem = dynamic_cast<CLVEasyItem*>(curItem);
			if( ezItem ) {		
				unsigned uin = atol(ezItem->GetColumnContentText(0));
			 	BMessage* sndMessage = new BMessage(GIMICQ_ADD_PERSON);
	 			sndMessage->AddInt32( "UIN", (int32)uin );
		 		if( ezItem->GetColumnContentText(1) )
		 			sndMessage->AddString( "NICKNAME", ezItem->GetColumnContentText(1) );
			 	mManager -> windows -> SendBuddyListMessage( sndMessage );
			}
			break;
		}

		default:
			BWindow::MessageReceived(msg);
	}
}


//-------------------------------------------------------------------------

void SearchResultsWindow::ParseIncomingResults( BMessage* msg ) {

	BString temp="";

	// add a "fake" item saying that the search failed
	if( msg->HasBool("failed") && msg->FindBool("failed") == true ) {
		resView->lview->RemoveItems( 0, resView->lview->CountItems() );
		SearchItem* failItem = new SearchItem("No matches were found.", true );
		failItem->SetEnabled( false );
		resView->lview->AddItem( failItem );
		return;
	}
	
	// if it's empty, clear it out
	if( empty ) {
		resView -> lview -> RemoveItems( 0, resView->lview->CountItems() );
		empty = false;
	}

	CLVEasyItem* item;
	item = new CLVEasyItem();
	temp << (unsigned)msg->FindInt32("UIN");

	item->SetColumnContent( 0, temp.String() );
	item->SetColumnContent( 1, msg->FindString("NICKNAME") );
	item->SetColumnContent( 2, msg->FindString("FIRSTNAME") );
	item->SetColumnContent( 3, msg->FindString("LASTNAME") );
	item->SetColumnContent( 4, msg->FindString("EMAIL") );
	temp = "  ";
	if( msg->FindBool("REQACK") == true )
		temp += _("text150");
	else {
		temp += " ";
		temp += _("text151");
	}
	item->SetColumnContent( 5, temp.String() );
	resView->lview->AddItem( item );
	
	statView->SetFoundAnother();
}

//-------------------------------------------------------------------------

void SearchResultsWindow::SetupNewSearch( BMessage* msg ) {

	/*
	char resTag[512];
	strcpy( resTag, "Search by " );

	switch( msg->FindInt32("type") ) {
		case 1: strcat( resTag, "e-mail address" );
				break;
		case 2: strcat( resTag, "nickname" );
			break;
		case 3: strcat( resTag, "first name" );
			break;			
		case 4: strcat( resTag, "last name" );
			break;	
	}
	
	strcat( resTag, ": " );
	strcat( resTag, (char*)msg->FindString("value") );
	resView->resLabel->SetText( resTag );*/
	
	// clear out the list
	resView -> lview -> RemoveItems( 0, resView->lview->CountItems() );
	empty = true;
}

//-------------------------------------------------------------------------

// the cancel function
void SearchResultsWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE )
			PostMessage( new BMessage(B_CANCEL) );
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

//=========================================================================

ResultsView::ResultsView(BRect rectory, const char *name, GManager *the_manager)
	   	   : BView(rectory, name, B_FOLLOW_ALL, B_WILL_DRAW | B_PULSE_NEEDED )
{
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;	

	BString temp;
	
	SetViewColor( 216, 216, 216 );	
	SetFontSize(11);
	
	// make the columnlistview
	BRect rect = Bounds();
	rect.right -= B_V_SCROLL_BAR_WIDTH;
	rect.top += 23;
	rect.bottom -= 54;// + B_H_SCROLL_BAR_HEIGHT + 12;
	//lview = new ResultsListView( rect );
	lview = new ResultsListView( rect, &container, mManager );
	//lview->SetFontSize(11);
	//container = new BScrollView( "scroller", lview ); 
	
	// add some columns
	columnUIN = new CLVColumn( _("label120") , 65, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnUIN );
	columnNick = new CLVColumn( _("label121") , 80, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnNick );
	columnFirst = new CLVColumn( _("label122") , 45, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnFirst );
	columnLast = new CLVColumn( _("label123") , 70, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnLast );
	columnEmail = new CLVColumn( _("label124") , 101, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnEmail );
	columnReqAck = new CLVColumn( _("label125") , 40, CLV_TELL_ITEMS_WIDTH | CLV_HEADER_TRUNCATE | CLV_NOT_MOVABLE );
	lview->AddColumn( columnReqAck );

	// make the search results label
	BRect boxRect = Bounds();
	boxRect.InsetBy( 5, 0 );
	boxRect.bottom = boxRect.top + 19;

	temp = _("label126");
	temp += ":"; 
	resLabel = new BStringView( boxRect, "resLabel", temp.String() );
	resLabel->SetFont(be_bold_font);
	resLabel->SetFontSize(12);
	
	// make some buttons
	BRect a_rect;
	a_rect = Bounds();
	a_rect.right -= 5;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 13;
	a_rect.top = a_rect.bottom - 20;	
	closeButton = new GButton( a_rect , "close", _("closebutton") , new BMessage(GIMICQ_CLOSE_WINDOW), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM );
	closeButton->MakeDefault( true );

	a_rect.left = 5;
	a_rect.right = a_rect.right + 80;
	addToListButton = new GButton( a_rect, "add", _("addbutton") , new BMessage(GIMICQ_TRY_ADD_PERSON), B_FOLLOW_LEFT | B_FOLLOW_BOTTOM );
	addToListButton->SetEnabled( false );
	
	a_rect.left += addToListButton -> Bounds().Width() + 7;
	a_rect.right = a_rect.left + 80;
	infoButton = new GButton( a_rect , "info", _("userinfobutton"), new BMessage(GIMICQ_GET_PERSON_INFO), B_FOLLOW_LEFT | B_FOLLOW_BOTTOM );
	infoButton->SetEnabled( false );

	// add the views
	AddChild( resLabel );
	AddChild( container );
	AddChild( addToListButton );
	AddChild( infoButton );
	AddChild( closeButton );
}

//-------------------------------------------------------------------------

void ResultsView::Pulse() {
}

//=========================================================================

ResultsListView::ResultsListView( BRect frame, BetterScrollView** container , GManager *the_manager)
		        : ColumnListView( frame, container, "results", B_FOLLOW_ALL_SIDES )
{
	mManager = the_manager;
	Locale *mLocale = mManager -> mLocale;

	BString t1,t2;
	t1 = _("menuitem100");
	t1 += B_UTF8_ELLIPSIS;
	t2 = _("menuitem101");
	t2 += B_UTF8_ELLIPSIS;
	userPopup = new BPopUpMenu( "userpopup", false );
	userPopup->AddItem( new BMenuItem( t1.String(), NULL ) );
	userPopup->AddItem( new BMenuItem( t2.String(), NULL ) );
}

//-------------------------------------------------------------------------

ResultsListView::~ResultsListView() {
	delete userPopup;
}

//-------------------------------------------------------------------------

void ResultsListView::MouseDown( BPoint cursor ) {

	uint32 buttons;
	int32 clickIndex;
	SearchItem* clickItem;
	BMenuItem* selected;
	int32 option;

	// get the mouse position
	GetMouse( &cursor, &buttons );
		
	// it was a right mouse button click, popup the menu
	if( buttons & B_SECONDARY_MOUSE_BUTTON ) {
		
		// get the index of the item the user clicked on, and select it
		clickIndex = IndexOf(cursor);
		if( clickIndex < 0 )			// not an item?
			return;
		Select(clickIndex);
		clickItem = (SearchItem*)ItemAt(clickIndex);

		// it's all good... display the popup menu
		ConvertToScreen( &cursor );
		selected = userPopup->Go( cursor );

		// if the user selected something, take action based on the choice
		if( selected ) {
			option = userPopup->IndexOf(selected);
			switch( option ) {
				case 0:
					Window()->PostMessage( new BMessage(GIMICQ_TRY_ADD_PERSON) );
					break;
				case 1:
					Window()->PostMessage( new BMessage(GIMICQ_GET_PERSON_INFO) );
					break;				
			}
		}
	} else
		BListView::MouseDown( cursor );
}

//-------------------------------------------------------------------------

void ResultsListView::SelectionChanged() {

	// Based on whether something is selected, send a message to disable the buttons
	int32 selected = CurrentSelection();
	BMessage* sndMessage = new BMessage(ENABLE_CONTEXT_BUTTONS);
	sndMessage->AddBool( "enabled", selected < 0 ? false : true );
	Window()->PostMessage( sndMessage );
	delete sndMessage;	
}

//=========================================================================

StatusView::StatusView(BRect rect, GManager *the_manager)
	   	   : BView(rect, "BuddyListStatus", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_BOTTOM, B_WILL_DRAW )
{
	mManager = the_manager;
	mLocale = mManager -> mLocale;
	
	SetFontSize(12);
	SetViewColor( 230, 230, 230 );
	found = 0;
	searching = true;
	
	
	showString = _("text160");
	showString += B_UTF8_ELLIPSIS;
}

//-------------------------------------------------------------------------

void StatusView::Draw( BRect ) {

	BRect frame = Bounds();

	SetHighColor( 156, 154, 156 );		// dark grey
	BPoint start = frame.LeftTop();
	BPoint end = frame.RightTop();
	StrokeLine( start, end );
	
	SetHighColor( 0, 0, 0 );
	SetLowColor( 222, 219, 222 );
	SetFont(be_plain_font);	
	SetFontSize(11);
	
	if( searching )
		MovePenTo(frame.left + 60, frame.bottom-2);
	else
		MovePenTo(frame.left + 4, frame.bottom-2);
	
	DrawString( showString.String() );
}

//-------------------------------------------------------------------------

void StatusView::MouseDown( BPoint point ) {
	
	BView::MouseDown( point );
}

//-------------------------------------------------------------------------

void StatusView::SetFoundAnother() {
	showString = _("text160");
	showString += " (";
	showString << ++found;
	showString += " ";
	showString += _("text161");
	showString += ")";
	Invalidate();
}

//-------------------------------------------------------------------------

void StatusView::SetDone( bool more ) {
	searching = false;
	if( more )
		showString = _("text162");
	else {
		showString = _("text163");
		showString += " - ";
		if( found ) {
			showString << found;
			if(found == 1)
				showString += _("text164");
			else
				showString += _("text165");
			showString += " found.";
		} else {
			showString += _("text165");
		}
	}
	Invalidate();
}

//=========================================================================
