#include <Debug.h>
#include "SearchForUser.h"

#include <RadioButton.h>
#include <TextControl.h>
#include <Box.h>
#include <String.h>

#include <stdlib.h>

#include "GButton.h"
#include "Say.h"
#include "GManager.h"
#include "WindowManager.h"
#include "Gicq.h"
#include "Locale.h"

#define BCQ_AU_SEARCH_UIN		'BAuU'
#define BCQ_AU_SEARCH_NAME		'BAuN'
#define BCQ_AU_SEARCH_EMAIL		'BAuE'
#define BCQ_AU_SEARCH			'BAuS'

SearchUserWindow::SearchUserWindow( BRect frame, BView* offsetTo, GManager *the_manager )
	: BWindow(frame, the_manager -> _("title7"), B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	mManager = the_manager;
	mLocale = mManager -> mLocale;
	
	BString temp;

	BRect			bounds = Bounds();
	BRadioButton	*auB;
	GButton			*search;
	GButton			*cancel;
	
	offsetter = offsetTo;

	choice = 1;
	
	Lock();
	auView = new BView(bounds, "SearchView", 0, B_WILL_DRAW | B_NOT_RESIZABLE);
	auView -> SetViewColor(216, 216, 216);
	
	
	temp = _("label130");
	temp += ":";
	auB = new BRadioButton(BRect(5, 7, bounds.right - 5, 22), "UIN", temp.String() , new BMessage(BCQ_AU_SEARCH_UIN));
	auB -> SetValue(true);
	auB->SetFont(be_bold_font);
	auB->SetFontSize(11);
	auView -> AddChild(auB);	
	
	temp = _("label131");
	temp += ":";
	auUIN = new BTextControl(BRect(21, 25, bounds.right - 5, 45), "UIN", temp.String() , "", 0);
	auUIN->SetFontSize(11);
	auUIN -> SetDivider(60);
	auView -> AddChild(auUIN);

	temp = _("label132");
	temp += ":";
	auB = new BRadioButton(BRect(5, 55, bounds.right - 5, 75), "NAME", temp.String(), new BMessage(BCQ_AU_SEARCH_NAME));
	auB->SetFont(be_bold_font);
	auB->SetFontSize(11);	
	auView -> AddChild(auB);

	temp = _("label133");
	temp += ":";
	auNick = new BTextControl(BRect(21, 72, bounds.right - 5, 90), "NICK", temp.String() , "", 0);
	auNick->SetFontSize(11);
	auNick -> SetDivider(60);
	auNick -> SetEnabled(false);
	auView -> AddChild(auNick);

	temp = _("label134");
	temp += ":";
	auFirst = new BTextControl(BRect(21, 93, bounds.right - 5, 110), "FIRST", temp.String() , "", 0);
	auFirst->SetFontSize(11);
	auFirst -> SetDivider(60);
	auFirst -> SetEnabled(false);
	auView -> AddChild(auFirst);

	temp = _("label135");
	temp += ":";
	auLast = new BTextControl(BRect(21, 114, bounds.right - 5, 130), "LAST", temp.String() , "", 0);
	auLast->SetFontSize(11);
	auLast -> SetDivider(60);
	auLast -> SetEnabled(false);
	auView -> AddChild(auLast);

	temp = _("label136");
	temp += ":";
	auB = new BRadioButton(BRect(5, 144, bounds.right-5, 160), "EMAIL", temp.String() , new BMessage(BCQ_AU_SEARCH_EMAIL));
	auB->SetFont(be_bold_font);
	auB->SetFontSize(11);
	auView -> AddChild(auB);

	temp = _("label137");
	temp += ":";
	auEmail = new BTextControl(BRect(21, 161, bounds.right - 5, 160), "EMAIL", temp.String(), "", 0);
	auEmail -> SetEnabled(false);
	auEmail->SetFontSize(11);
	auEmail -> SetDivider(60);
	auView -> AddChild(auEmail);
	
	// Make the groovy little line
	BBox* divider = new BBox(BRect(11,192,bounds.right-11,194),"divider", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW, B_FANCY_BORDER);	
	auView->AddChild( divider );
	
	BRect a_rect;
	a_rect = Bounds();
	a_rect.right -= 8;
	a_rect.left = a_rect.right - 80;
	a_rect.bottom -= 10;
	a_rect.top = a_rect.bottom - 20;
	cancel = new GButton(	a_rect , "Cancel", _("cancelbutton"), new BMessage(B_CANCEL) );	
	auView -> AddChild(cancel);

	a_rect.right -= cancel -> Bounds().Width() + 7;
	a_rect.left = a_rect.right - 80;
	search = new GButton(	a_rect , "search", _("button4"), new BMessage(BCQ_AU_SEARCH) );	
	auView -> AddChild(search);
	search -> MakeDefault(true);
	

		
	AddChild(auView);
	auUIN -> MakeFocus(true);
	Unlock();
}

SearchUserWindow::~SearchUserWindow() {
	mManager -> windows -> CloseGeneralWindow(this);
}


void SearchUserWindow::MessageReceived(BMessage *inMessage)
{

	switch (inMessage -> what)
	{
		case BCQ_AU_SEARCH_NAME:
			auUIN -> SetEnabled(false);
			auNick  -> SetEnabled(true);
			auFirst -> SetEnabled(true);
			auLast  -> SetEnabled(true);
			auEmail -> SetEnabled(false);
			
			auNick -> MakeFocus(true);
			choice = 2;
			break;
			
		case BCQ_AU_SEARCH_EMAIL:
			auUIN -> SetEnabled(false);
			auEmail -> SetEnabled(true);
			auNick  -> SetEnabled(false);
			auFirst -> SetEnabled(false);
			auLast  -> SetEnabled(false);
	
			auEmail -> MakeFocus(true);
			choice = 3;
			break;
	
		case BCQ_AU_SEARCH_UIN:
			auUIN -> SetEnabled(true);
			auEmail -> SetEnabled(false);
			auNick  -> SetEnabled(false);
			auFirst -> SetEnabled(false);
			auLast  -> SetEnabled(false);
	
			auUIN -> MakeFocus(true);
			choice = 1;
			break;
			
		case B_CANCEL:
			QuitRequested();
			Close();
			break;
			
		
		case BCQ_AU_SEARCH:
			{
/*				BRect aRect;
				BRect bRect = BScreen(B_MAIN_SCREEN_ID).Frame();

				aRect.top = bRect.top + 24;
				aRect.right = bRect.right - 125;
				aRect.bottom = 174;
				aRect.left = bRect.right - 245;
				BeCQCLWindow *con = new BeCQCLWindow(BRect(aRect.right - 500, 100, aRect.right - 40, 250), thisServer, 0);

				if (choice == 1)
				{
					search_id = thisServer -> SearchUIN(atol(auUIN -> Text()), con -> Looper());
				}
				
				else if (choice == 2)
				{
					search_id = thisServer -> SearchUser(auNick -> Text(), auFirst -> Text(), auLast -> Text(), "", con -> Looper());
				}
			
				else
				{
					search_id = thisServer -> SearchUser("", "", "", auEmail -> Text(), con -> Looper());
				}

				con -> SetSearchID(search_id);
				Close();*/
				
				// make the search message and set empty fields
				BMessage* m = new BMessage( ICQ_USER_SEARCH );
				m -> AddString( "EMAIL", "" );
				m -> AddInt32( "LENGTH_EMAIL", 0 );
				m -> AddString( "FIRSTNAME", "" );
				m -> AddInt32( "LENGTH_FIRST", 0 );
				m -> AddString( "LASTNAME", "" );
				m -> AddInt32( "LENGTH_LAST", 0 );
				m -> AddString( "NICKNAME", "" );
				m -> AddInt32( "LENGTH_NICK", 0 );

				if( choice == 1 ) {
					if( strlen(auUIN->Text()) == 0 ) {
						Say( _("text170") );
						auUIN->MakeFocus(true);
						return;
					}
					//BMessage* srchMsg = new BMessage( ICQ_USER_SEARCH );
					//srchMsg->AddInt32( "UIN", (int32)atol(auUIN->Text()) );
					//mManager -> icq->PostMessage( srchMsg );

					/*  m is now GIMICQ_OPEN_USER_WINDOW */ 
					m->what = GIMICQ_OPEN_USER_WINDOW; 
					m->AddInt32( "UIN", (int32)(int32)atol(auUIN->Text()) );	
					m->AddInt32( "wtype", (int32)USER_INFO_TYPE );
					m->AddPointer( "poswindow", offsetter );
					mManager -> windows -> SendBuddyListMessage(m);
				
				} else if( choice == 2 ) {
					if( (strlen(auNick->Text()) == 0) && (strlen(auFirst->Text()) == 0) && (strlen(auLast->Text()) == 0) ) {
						Say( _("text171") );
						return;
					}
					
					m->ReplaceString( "FIRSTNAME", auFirst->Text() );
					m->ReplaceInt32( "LENGTH_FIRST", strlen(auFirst->Text()) );
					m->ReplaceString( "LASTNAME", auLast->Text() );
					m->ReplaceInt32( "LENGTH_LAST", strlen(auLast->Text()) );
					m->ReplaceString( "NICKNAME", auNick->Text() );
					m->ReplaceInt32( "LENGTH_NICK", strlen(auNick->Text()) );
					mManager -> icq->PostMessage( m );
					mManager -> windows -> SendBuddyListMessage( new BMessage(GIMICQ_OPEN_EMAIL_SEARCH) );
				}

				else if( choice == 3 ) {
					if( strlen(auEmail->Text()) == 0 ) {
						Say( _("text172") );
						auEmail->MakeFocus(true);
						return;
					}
					m->ReplaceString( "EMAIL", auEmail->Text() );
					m->ReplaceInt32( "LENGTH_EMAIL", strlen(auEmail->Text()) );
					mManager -> icq->PostMessage( m );
					mManager -> windows -> SendBuddyListMessage( new BMessage(GIMICQ_OPEN_EMAIL_SEARCH) );
				}
				
				
//				QuitRequested();
//				Close();
			}
			break;
			
		default:
			BWindow::MessageReceived(inMessage);
			break;
	}
}


// the cancel function
void SearchUserWindow::DispatchMessage( BMessage* msg, BHandler* handler ) {

	// if it's a cancel key, post a B_CANCEL message
	if( msg->what == B_KEY_DOWN )
		if( msg->HasString("bytes") && msg->FindString("bytes")[0] == B_ESCAPE ) {
			PostMessage( new BMessage(B_CANCEL) );
			return;
		}
	
	// our work here is done... dispatch normally
	BWindow::DispatchMessage( msg, handler );
}

//-------------------------------------------------------------------------

