/*	BitmapView.h
 */

#ifndef BitmapView_h
#define BitmapView_h

#include <View.h>

class BBitmap;

class BitmapView :
	public BView
{
public:
								BitmapView(
									BBitmap *		map,
									const char *	comment);
								~BitmapView();

		void					SetOwnership(
									bool			own);
		bool					GetOwnership();
		void					SetBitmap(
									BBitmap *		map);
		BBitmap *				GetBitmap();
		void					SetAdjustBars(
									bool			adjusts);
		bool					GetAdjustBars();
		BRect					GetMargins();
		void					SetMargins(
									BRect margins);

		void					Draw(
									BRect			area);
		void					MouseDown(
									BPoint			where);
		void					FrameResized(
									float			newWidth,
									float			newHeight);
		void					WindowActivated(
									bool			state);

protected:

		BRect					fMargins;
		BBitmap *				fBitmap;
		bool					fAdjustBars;
		bool					fOwnership;
		BPoint					fCommentPos;
		char					fComment[256];
		bool					fDrawComment;

		void					AdjustBars();
};

#endif
