//Hammurabi
//Matt Wronkiewicz, 1997 10 12

#include <stdio.h>
#include <StorageKit.h>
#include "Hammurabi.h"
#include "HamConsole.h"
#include "HamAlert.h"

#define HAM_APP_SIGNATURE "application/x-vnd.ft-ham"

Hammurabi::Hammurabi ()
	:BApplication(HAM_APP_SIGNATURE)
	{
	entry_ref ref;
	app_info ainfo;
	status_t err = be_app->GetAppInfo(&ainfo);
	ref = ainfo.ref;
	if (err != B_OK)
		err = be_roster->FindApp(HAM_APP_SIGNATURE, &ref);
	if (err != B_OK)
		{
		char message[128];
		sprintf(message, "Hammurabi encountered the system error %d while initializing.", (int)err);
		(new BAlert("", message, "Quit"))->Go();
		PostMessage(B_QUIT_REQUESTED);
		return;
		}
	BFile app_file(&ref, O_RDONLY);
	rsrcs = new BResources();
	err = rsrcs->SetTo(&app_file);
	if (err != B_OK)
		{
		char message[128];
		sprintf(message, "Hammurabi was unable to load its resources.");
		(new BAlert("", message, "Quit"))->Go();
		PostMessage(B_QUIT_REQUESTED);
		return;
		}
	
	HamConsole* console = new HamConsole();
	console->Show();
	}

status_t Hammurabi::GetResource(const char* name, BMessage* msg)
	{
	size_t len;
	int32 res_id;
	bool res_found = rsrcs->GetResourceInfo('ARCV', name, &res_id, &len);
	if (!res_found)
		return B_ERROR;
	status_t err;
	char* data = new char[len];
	err = rsrcs->ReadResource('ARCV', res_id, data, 0, len);
	if (err != B_OK)
		return err;
	err = msg->Unflatten(data);
	return err;
	}
