/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZoneData;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private String ID;
    private static TimeZone defaultZone = null;
    private static final String DEFAULT_SHORT_ID = "GMT";
    private static final String DEFAULT_ID = "Africa/Casablanca";
    private static final String[] idMap = new String[]{"GMT", "Africa/Casablanca", "ECT", "Europe/Paris", "EET", "Africa/Cairo", "EAT", "Asia/Riyadh", "MET", "Asia/Tehran", "NET", "Asia/Yerevan", "PLT", "Asia/Karachi", "IST", "Asia/Calcutta", "BST", "Asia/Dacca", "VST", "Asia/Bangkok", "CTT", "Asia/Shanghai", "JST", "Asia/Tokyo", "ACT", "Australia/Adelaide", "AET", "Australia/Sydney", "SST", "Pacific/Guadalcanal", "NST", "Pacific/Auckland", "MIT", "Pacific/Apia", "HST", "Pacific/Honolulu", "AST", "America/Anchorage", "PST", "America/Los_Angeles", "MST", "America/Denver", "CST", "America/Chicago", "EST", "America/New_York", "PRT", "America/Halifax", "CNT", "America/St_Johns", "AGT", "America/Buenos_Aires", "BET", "America/Sao_Paulo", "CAT", "Atlantic/Azores"};
    private static Hashtable idlookup = new Hashtable(idMap.length / 2);

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = string.length() <= 3 ? TimeZoneData.get(string) : null;
        if (timeZone != null) {
            return timeZone;
        }
        return TimeZoneData.get(DEFAULT_SHORT_ID);
    }

    public static synchronized String[] getAvailableIDs(int n) {
        String[] stringArray = new String[13];
        int n2 = 0;
        int n3 = 0;
        while (n3 < TimeZoneData.zones.length) {
            if (n == TimeZoneData.zones[n3].getRawOffset() && TimeZoneData.zones[n3].getID().length() <= 3) {
                stringArray[n2++] = TimeZoneData.zones[n3].getID();
            }
            ++n3;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public static synchronized String[] getAvailableIDs() {
        String[] stringArray = new String[TimeZoneData.zones.length];
        int n = 0;
        int n2 = 0;
        while (n2 < TimeZoneData.zones.length) {
            if (TimeZoneData.zones[n2].getID().length() <= 3) {
                stringArray[n++] = TimeZoneData.zones[n2].getID();
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static synchronized TimeZone getDefault() {
        if (defaultZone == null) {
            String string = System.getProperty("user.timezone", DEFAULT_SHORT_ID);
            String string2 = (String)idlookup.get(string);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                string = DEFAULT_ID;
            }
            string = TimeZoneData.mapLongIDtoShortID(string);
            defaultZone = TimeZone.getTimeZone(string);
        }
        return (TimeZone)defaultZone.clone();
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultZone = timeZone;
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        int n = 0;
        while (n < idMap.length) {
            idlookup.put(idMap[n], idMap[n + 1]);
            n += 2;
        }
    }
}

