/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethod;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFontPeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WPrintJob;
import sun.awt.windows.WScrollPanePeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WWindowPeer;

public class WToolkit
extends SunToolkit
implements Runnable {
    static final boolean enableDebug = true;
    boolean dbgTrace = false;
    private static final String propTrace = "WINAWT.Trace";
    boolean dbgVerify = false;
    private static final String propVerify = "WINAWT.VerifyComponents";
    boolean dbgBreak = false;
    private static final String propBreak = "WINAWT.BreakOnFailure";
    boolean dbgHeapCheck = false;
    private static final String propHeapCheck = "WINAWT.HeapCheck";
    WClipboard clipboard;
    static ColorModel screenmodel;

    public WToolkit() {
        this.InitializeDebuggingOptions();
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            Thread thread = new Thread(this, "AWT-Windows");
            thread.setDaemon(false);
            thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    private void InitializeDebuggingOptions() {
        String string = Toolkit.getProperty(propTrace, "false");
        this.dbgTrace = Boolean.valueOf(string);
        string = Toolkit.getProperty(propVerify, "false");
        this.dbgVerify = Boolean.valueOf(string);
        string = Toolkit.getProperty(propBreak, "false");
        this.dbgBreak = Boolean.valueOf(string);
        string = Toolkit.getProperty(propHeapCheck, "false");
        this.dbgHeapCheck = Boolean.valueOf(string);
    }

    public native void init(Thread var1);

    public void run() {
        Thread thread = Thread.currentThread();
        this.init(thread);
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            this.notifyAll();
        }
        this.eventLoop();
    }

    native void eventLoop();

    static void postEvent(AWTEvent aWTEvent) {
        SunToolkit.theEventQueue.postEvent(aWTEvent);
    }

    public ButtonPeer createButton(Button button) {
        WButtonPeer wButtonPeer = new WButtonPeer(button);
        SunToolkit.peerMap.put(button, wButtonPeer);
        return wButtonPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        WTextFieldPeer wTextFieldPeer = new WTextFieldPeer(textField);
        SunToolkit.peerMap.put(textField, wTextFieldPeer);
        return wTextFieldPeer;
    }

    public LabelPeer createLabel(Label label) {
        WLabelPeer wLabelPeer = new WLabelPeer(label);
        SunToolkit.peerMap.put(label, wLabelPeer);
        return wLabelPeer;
    }

    public ListPeer createList(List list) {
        WListPeer wListPeer = new WListPeer(list);
        SunToolkit.peerMap.put(list, wListPeer);
        return wListPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        WCheckboxPeer wCheckboxPeer = new WCheckboxPeer(checkbox);
        SunToolkit.peerMap.put(checkbox, wCheckboxPeer);
        return wCheckboxPeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        WScrollbarPeer wScrollbarPeer = new WScrollbarPeer(scrollbar);
        SunToolkit.peerMap.put(scrollbar, wScrollbarPeer);
        return wScrollbarPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        WScrollPanePeer wScrollPanePeer = new WScrollPanePeer(scrollPane);
        SunToolkit.peerMap.put(scrollPane, wScrollPanePeer);
        return wScrollPanePeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        WTextAreaPeer wTextAreaPeer = new WTextAreaPeer(textArea);
        SunToolkit.peerMap.put(textArea, wTextAreaPeer);
        return wTextAreaPeer;
    }

    static native int getComboHeightOffset();

    public ChoicePeer createChoice(Choice choice) {
        WChoicePeer wChoicePeer = new WChoicePeer(choice);
        SunToolkit.peerMap.put(choice, wChoicePeer);
        return wChoicePeer;
    }

    public FramePeer createFrame(Frame frame) {
        WFramePeer wFramePeer = new WFramePeer(frame);
        SunToolkit.peerMap.put(frame, wFramePeer);
        return wFramePeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        WCanvasPeer wCanvasPeer = new WCanvasPeer(canvas);
        SunToolkit.peerMap.put(canvas, wCanvasPeer);
        return wCanvasPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        WPanelPeer wPanelPeer = new WPanelPeer(panel);
        SunToolkit.peerMap.put(panel, wPanelPeer);
        return wPanelPeer;
    }

    public WindowPeer createWindow(Window window) {
        WWindowPeer wWindowPeer = new WWindowPeer(window);
        SunToolkit.peerMap.put(window, wWindowPeer);
        return wWindowPeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        WDialogPeer wDialogPeer = new WDialogPeer(dialog);
        SunToolkit.peerMap.put(dialog, wDialogPeer);
        return wDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        WFileDialogPeer wFileDialogPeer = new WFileDialogPeer(fileDialog);
        SunToolkit.peerMap.put(fileDialog, wFileDialogPeer);
        return wFileDialogPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = new WMenuBarPeer(menuBar);
        SunToolkit.peerMap.put(menuBar, wMenuBarPeer);
        return wMenuBarPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        WMenuPeer wMenuPeer = new WMenuPeer(menu);
        SunToolkit.peerMap.put(menu, wMenuPeer);
        wMenuPeer.create();
        return wMenuPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        WPopupMenuPeer wPopupMenuPeer = new WPopupMenuPeer(popupMenu);
        SunToolkit.peerMap.put(popupMenu, wPopupMenuPeer);
        return wPopupMenuPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        WMenuItemPeer wMenuItemPeer = new WMenuItemPeer(menuItem);
        SunToolkit.peerMap.put(menuItem, wMenuItemPeer);
        return wMenuItemPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        WCheckboxMenuItemPeer wCheckboxMenuItemPeer = new WCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.peerMap.put(checkboxMenuItem, wCheckboxMenuItemPeer);
        return wCheckboxMenuItemPeer;
    }

    public WEmbeddedFramePeer createEmbeddedFrame(WEmbeddedFrame wEmbeddedFrame) {
        WEmbeddedFramePeer wEmbeddedFramePeer = new WEmbeddedFramePeer(wEmbeddedFrame);
        SunToolkit.peerMap.put(wEmbeddedFrame, wEmbeddedFramePeer);
        return wEmbeddedFramePeer;
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        WImage wImage = (WImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : wImage.getImageRep().check(imageObserver);
        return wImage.check(imageObserver) | n3;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = WToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    public native int getScreenResolution();

    protected native int getScreenWidth();

    protected native int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public FontPeer getFontPeer(String string, int n) {
        return new WFontPeer(string, n);
    }

    public native void sync();

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        WPrintJob wPrintJob = null;
        try {
            wPrintJob = new WPrintJob(string);
        }
        catch (IOException iOException) {}
        return wPrintJob.initJob();
    }

    public native void beep();

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new WClipboard();
        }
        return this.clipboard;
    }

    protected native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public InputMethod getInputMethodAdapter() {
        return null;
    }

    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    static {
        System.loadLibrary("winawt");
    }
}

