/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.xfile.XFile;
import java.io.IOException;

public class XFileAccessor
implements com.sun.xfile.XFileAccessor {
    XFile xf;
    boolean serial;
    boolean readOnly;
    Nfs nfs;

    public boolean open(XFile xFile, boolean bl, boolean bl2) {
        this.xf = xFile;
        try {
            this.nfs = NfsConnect.connect(xFile.getAbsolutePath());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public XFile getXFile() {
        return this.xf;
    }

    protected Nfs getParent(XFile xFile) throws IOException {
        XFile xFile2 = new XFile(xFile.getParent());
        XFileAccessor xFileAccessor = new XFileAccessor();
        xFileAccessor.open(xFile2, this.serial, this.readOnly);
        return xFileAccessor.getNfs();
    }

    protected Nfs getNfs() {
        return this.nfs;
    }

    public boolean exists() {
        try {
            return this.nfs.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canWrite() {
        try {
            return this.nfs.canWrite();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean canRead() {
        try {
            return this.nfs.canRead();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isFile() {
        try {
            return this.nfs.isFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            return this.nfs.isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long lastModified() {
        try {
            return this.nfs.mtime();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long length() {
        try {
            return this.nfs.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public boolean mkfile() {
        try {
            this.nfs = this.getParent(this.xf).create(this.xf.getName(), 438L);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean mkdir() {
        try {
            this.nfs = this.getParent(this.xf).mkdir(this.xf.getName(), 511L);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean renameTo(XFile xFile) {
        try {
            Nfs nfs = this.getParent(this.xf);
            Nfs nfs2 = this.getParent(xFile);
            return nfs.rename(nfs2, this.xf.getName(), xFile.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String[] list() {
        try {
            return this.nfs.readdir();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean delete() {
        try {
            boolean bl = this.isFile() ? this.getParent(this.xf).remove(this.xf.getName()) : this.getParent(this.xf).rmdir(this.xf.getName());
            if (bl) {
                this.nfs.invalidate();
                this.nfs = null;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int read(byte[] byArray, int n, int n2, long l) throws IOException {
        int n3 = this.nfs.read(byArray, n, n2, l);
        return n3;
    }

    public void write(byte[] byArray, int n, int n2, long l) throws IOException {
        this.nfs.write(byArray, n, n2, l);
    }

    public void flush() throws IOException {
        this.nfs.flush();
    }

    public void close() throws IOException {
        this.nfs.close();
    }

    public String toString() {
        return this.nfs.toString();
    }
}

