/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.RpcException;

public class MsgRejectedException
extends RpcException {
    int lo;
    int hi;
    int why;
    public static final int RPC_MISMATCH = 0;
    public static final int AUTH_ERROR = 1;
    public static final int AUTH_BADCRED = 1;
    public static final int AUTH_REJECTEDCRED = 2;
    public static final int AUTH_BADVERF = 3;
    public static final int AUTH_REJECTEDVERF = 4;
    public static final int AUTH_TOOWEAK = 5;
    public static final int AUTH_INVALIDRESP = 6;
    public static final int AUTH_FAILED = 7;

    public MsgRejectedException(int n) {
        super(n);
    }

    public MsgRejectedException(int n, int n2) {
        super(n);
        this.why = n2;
    }

    public MsgRejectedException(int n, int n2, int n3) {
        super(n);
        this.lo = n2;
        this.hi = n3;
    }

    public String toString() {
        switch (this.error) {
            case 0: {
                return "Version mismatch: low=" + this.lo + ",high=" + this.hi;
            }
            case 1: {
                String string = "Authentication error: ";
                switch (this.why) {
                    case 1: {
                        string = String.valueOf(string) + "bogus credentials (seal broken)";
                        break;
                    }
                    case 2: {
                        string = String.valueOf(string) + "client should begin new session";
                        break;
                    }
                    case 3: {
                        string = String.valueOf(string) + "bogus verifier (seal broken)";
                        break;
                    }
                    case 4: {
                        string = String.valueOf(string) + "verifier expired or was replayed";
                        break;
                    }
                    case 5: {
                        string = String.valueOf(string) + "too weak";
                        break;
                    }
                    case 6: {
                        string = String.valueOf(string) + "bogus response verifier";
                        break;
                    }
                    default: {
                        string = String.valueOf(string) + "unknown reason";
                    }
                }
                return string;
            }
        }
        return "Unknown RPC Error = " + this.error;
    }
}

