/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Certificate;
import java.security.Identity;
import java.util.Hashtable;
import java.util.Vector;
import sunw.hotjava.applet.AppletClassEntry;
import sunw.hotjava.applet.AppletIOException;
import sunw.hotjava.applet.AppletLoadRedirectException;
import sunw.hotjava.applet.AppletResourceLoader;
import sunw.hotjava.applet.AppletSecurityContext;
import sunw.hotjava.applet.BasicAppletManager;
import sunw.hotjava.applet.HotJavaClassLoader;
import sunw.hotjava.applet.ScriptingEngineLoader;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.security.AppletSecurityException;
import sunw.hotjava.security.CertificateTrust;
import sunw.hotjava.security.TrustManager;

public class AppletClassLoader
extends ClassLoader
implements HotJavaClassLoader {
    private static String propPrefix = "appletclassloader.";
    Vector archives = new Vector();
    URL base;
    Object dom;
    AppletResourceLoader resources;
    protected Hashtable rawClasses = new Hashtable();
    private BasicAppletManager appletManager;

    public void destroy() {
        this.archives = null;
        this.base = null;
        this.dom = null;
        this.resources = null;
        this.rawClasses = null;
        this.appletManager = null;
    }

    AppletClassLoader(URL uRL, BasicAppletManager basicAppletManager, Object object) {
        this.dom = object;
        this.appletManager = basicAppletManager;
        this.base = uRL;
        this.resources = new AppletResourceLoader(this);
    }

    URL getCodeBase() {
        return this.base;
    }

    Object getDOM() {
        return this.dom;
    }

    public Object getSecurityContext() {
        return new AppletSecurityContext(this.base, this.dom);
    }

    private boolean hostsEqual(URL uRL, URL uRL2) {
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        return this.hostsEqual(string, string2);
    }

    private boolean hostsEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            return inetAddress.equals(inetAddress2);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        return false;
    }

    URL makeRelativeURLWithSecurity(URL uRL, String string) throws IOException {
        URL uRL2 = new URL(uRL, string);
        String string2 = uRL.getHost();
        String string3 = uRL2.getHost();
        if (!uRL.getProtocol().equals(uRL2.getProtocol()) || string2 == null && string3 != null || string2 != null && !string2.equals(string3) || uRL.getPort() != uRL2.getPort()) {
            throw new AppletIOException("throw.illegal.relative", string);
        }
        return uRL2;
    }

    InputStream openRelativeURLWithSecurity(URL uRL, String string) throws IOException {
        URL uRL2 = this.makeRelativeURLWithSecurity(uRL, string);
        URLConnection uRLConnection = this.checkRedirects(uRL2.openConnection());
        return this.openConnection(uRLConnection);
    }

    URLConnection checkRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            this.tryToStopFollowRedirects(uRLConnection);
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 305 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !this.hostsEqual(uRL, uRL2) || n >= 5) {
                throw new AppletLoadRedirectException("loadclass.throw.redirect", uRL, uRL2);
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return uRLConnection;
    }

    InputStream openConnection(URLConnection uRLConnection) throws IOException {
        return uRLConnection.getInputStream();
    }

    private void tryToStopFollowRedirects(URLConnection uRLConnection) {
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return;
        }
        Class<?> clazz = uRLConnection.getClass();
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        classArray[0] = Boolean.TYPE;
        objectArray[0] = new Boolean(false);
        try {
            Method method = clazz.getMethod("setInstanceFollowRedirects", classArray);
            method.invoke((Object)uRLConnection, objectArray);
            return;
        }
        catch (Exception exception) {
            System.out.println("Cookies with redirection probably won't work");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class loadClass(String string, URL uRL) throws IOException {
        Class<?> clazz;
        InputStream inputStream = null;
        try {
            try {
                int n;
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setAllowUserInteraction(false);
                uRLConnection = this.checkRedirects(uRLConnection);
                inputStream = this.openConnection(uRLConnection);
                int n2 = uRLConnection.getContentLength();
                byte[] byArray = new byte[n2 == -1 ? 4096 : n2];
                int n3 = 0;
                Thread thread = Thread.currentThread();
                while ((n = inputStream.read(byArray, n3, byArray.length - n3)) >= 0 && !thread.isInterrupted()) {
                    if ((n3 += n) != byArray.length) continue;
                    if (n2 >= 0) break;
                    byte[] byArray2 = new byte[n3 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                if (thread.isInterrupted()) {
                    throw new AppletIOException("loadclass.throw.interrupted", uRL);
                }
                this.setAccSuperBit(byArray, 0, n3);
                clazz = this.defineClass(string, byArray, 0, n3);
                Object var6_14 = null;
                if (inputStream == null) return clazz;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                System.out.println(string);
                throwable.printStackTrace();
                throw new AppletIOException("loadclass.throw.notloaded", uRL);
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return clazz;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        block8: {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                int n;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                    securityManager.checkPackageAccess(string.substring(0, n));
                }
                try {
                    return this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ScriptingEngineLoader scriptingEngineLoader;
                    clazz = this.findClass(string);
                    if (clazz == null && (scriptingEngineLoader = ScriptingEngineLoader.getLoader()) != null) {
                        try {
                            clazz = ((ClassLoader)((Object)scriptingEngineLoader)).loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {}
                    }
                    if (clazz != null) break block8;
                    throw new ClassNotFoundException(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized Class loadCode(String string, String string2, String string3) throws ClassNotFoundException, IOException {
        Class clazz;
        block38: {
            Class<?> clazz2;
            String string4 = null;
            int n = string3.lastIndexOf(46);
            string4 = n < 0 ? "" : string3.substring(0, n);
            int n2 = 0;
            boolean bl = false;
            TrustManager trustManager = TrustManager.getTrustManager();
            if (trustManager != null) {
                CertificateTrust[] certificateTrustArray = trustManager.getSessionSites();
                String string5 = this.base.getHost();
                int n3 = 0;
                while (n3 < certificateTrustArray.length) {
                    if (this.hostsEqual(string5, certificateTrustArray[n3].getName())) {
                        n2 = certificateTrustArray[n3].getMode();
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl && n2 == 9) {
                throw new AppletSecurityException("checkpackageaccess", string4);
            }
            boolean bl2 = Boolean.getBoolean("hotjava.appletsJS.enableApplets");
            boolean bl3 = !System.getProperty("hotjava.default.signed.security").equalsIgnoreCase("untrusted");
            clazz = this.findLoadedClass(string3);
            if (clazz != null) {
                Object[] objectArray = clazz.getSigners();
                if (objectArray == null && !bl2 && !bl) {
                    throw new AppletSecurityException("checkpackageaccess", string4);
                }
                if (objectArray != null) {
                    boolean bl4 = false;
                    if (trustManager != null) {
                        int n4 = 0;
                        block12: while (n4 < objectArray.length) {
                            if (objectArray[n4] instanceof Identity) {
                                Certificate[] certificateArray = ((Identity)objectArray[n4]).certificates();
                                int n5 = 0;
                                while (n5 < certificateArray.length) {
                                    Certificate certificate = certificateArray[n5];
                                    CertificateTrust certificateTrust = trustManager.getTrustForCert(certificate);
                                    if (certificateTrust != null && certificateTrust.getMode() != 13) {
                                        bl4 = true;
                                        if (certificateTrust.getMode() == 9) {
                                            n2 = certificateTrust.getMode();
                                            break block12;
                                        }
                                    }
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                    if (bl4 ? n2 == 9 : !bl3 && !bl) {
                        throw new AppletSecurityException("checkpackageaccess", string4);
                    }
                }
                return clazz;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPackageAccess(string4);
            }
            try {
                return this.findSystemClass(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AppletClassEntry appletClassEntry;
                if (securityManager != null) {
                    securityManager.checkPackageDefinition(string4);
                }
                if ((appletClassEntry = (AppletClassEntry)this.rawClasses.get(string3)) == null) break block38;
                try {
                    Identity[] identityArray = appletClassEntry.ids;
                    if (identityArray == null && !bl2 && !bl) {
                        throw new AppletSecurityException("checkpackageaccess", string4);
                    }
                    if (identityArray != null) {
                        boolean bl5 = false;
                        if (trustManager != null) {
                            int n6 = 0;
                            block14: while (n6 < identityArray.length) {
                                if (identityArray[n6] instanceof Identity) {
                                    Certificate[] certificateArray = identityArray[n6].certificates();
                                    int n7 = 0;
                                    while (n7 < certificateArray.length) {
                                        Certificate certificate = certificateArray[n7];
                                        CertificateTrust certificateTrust = trustManager.getTrustForCert(certificate);
                                        if (certificateTrust != null && certificateTrust.getMode() != 13) {
                                            bl5 = true;
                                            if (certificateTrust.getMode() == 9) {
                                                n2 = certificateTrust.getMode();
                                                break block14;
                                            }
                                        }
                                        ++n7;
                                    }
                                }
                                ++n6;
                            }
                        }
                        if (bl5 ? n2 == 9 : !bl3 && !bl) {
                            throw new AppletSecurityException("checkpackageaccess", string4);
                        }
                    }
                    Class<?> clazz3 = super.defineClass(appletClassEntry.classBuf, appletClassEntry.start, appletClassEntry.len);
                    if (appletClassEntry.ids != null) {
                        this.setSigners(clazz3, appletClassEntry.ids);
                    }
                    clazz2 = clazz3;
                }
                catch (Throwable throwable) {
                    Object var16_30 = null;
                    this.rawClasses.remove(string3);
                    throw throwable;
                }
            }
            Object var16_29 = null;
            this.rawClasses.remove(string3);
            return clazz2;
        }
        try {
            URL uRL = new URL(this.base, String.valueOf(string) + string2);
            clazz = this.loadClass(string3, uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg("filenotfound", string3);
        }
        catch (ClassFormatError classFormatError) {
            this.errorMsg("fileformat", string3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg("fileexception", exception.toString(), string3);
        }
        catch (ThreadDeath threadDeath) {
            this.errorMsg("filedeath", string3);
            throw threadDeath;
        }
        catch (Error error) {
            this.errorMsg("fileerror", error.toString(), string3);
        }
        if (clazz != null) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    AppletClassEntry defineClassFromBytes(String string, byte[] byArray, int n, int n2) {
        this.setAccSuperBit(byArray, n, n2);
        AppletClassEntry appletClassEntry = new AppletClassEntry(byArray, n, n2, string, null);
        this.rawClasses.put(appletClassEntry, appletClassEntry);
        this.rawClasses.put(string, appletClassEntry);
        return appletClassEntry;
    }

    void errorMsg(String string, String string2) {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("securityProperties");
        String string3 = hJBProperties.getPropertyReplace(String.valueOf(propPrefix) + string, string2);
        System.err.println(string3);
    }

    void errorMsg(String string, String string2, String string3) {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("securityProperties");
        String string4 = hJBProperties.getPropertyReplace(String.valueOf(propPrefix) + string, string2, string3);
        System.err.println(string4);
    }

    private synchronized Class findClass(String string) {
        AppletClassEntry appletClassEntry;
        int n;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            securityManager.checkPackageDefinition(string.substring(0, n));
        }
        if ((appletClassEntry = (AppletClassEntry)this.rawClasses.get(string)) != null) {
            Class<?> clazz2;
            try {
                Class<?> clazz3 = super.defineClass(appletClassEntry.classBuf, appletClassEntry.start, appletClassEntry.len);
                if (appletClassEntry.ids != null) {
                    this.setSigners(clazz3, appletClassEntry.ids);
                }
                clazz2 = clazz3;
                Object var7_9 = null;
                this.rawClasses.remove(string);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.rawClasses.remove(string);
                throw throwable;
            }
            return clazz2;
        }
        String string2 = String.valueOf(string.replace('.', '/')) + ".class";
        try {
            URL uRL = new URL(this.base, string2);
            clazz = this.loadClass(string, uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg("filenotfound", string);
        }
        catch (ClassFormatError classFormatError) {
            this.errorMsg("fileformat", string);
        }
        catch (IOException iOException) {
            this.errorMsg("fileioexception", string);
        }
        catch (Exception exception) {
            this.errorMsg("fileexception", exception.toString(), string);
        }
        catch (ThreadDeath threadDeath) {
            this.errorMsg("filedeath", string);
            throw threadDeath;
        }
        catch (Error error) {
            this.errorMsg("fileerror", error.toString(), string);
        }
        return clazz;
    }

    public AppletResourceLoader getResourceLoader() {
        return this.resources;
    }

    private boolean resourceExists(URL uRL) {
        boolean bl = true;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                httpURLConnection.disconnect();
                if (n == 200) {
                    return true;
                }
                if (n >= 400) {
                    return false;
                }
            } else {
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        try {
            uRL = this.resources.getResourceAsURL(string);
            if (uRL != null) {
                return uRL;
            }
            uRL = new URL(this.base, string);
            if (!this.resourceExists(uRL)) {
                uRL = null;
            }
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        URL uRL = this.getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.appletManager.getThreadGroup(this.base);
    }

    private void setAccSuperBit(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n + n2, byArray.length);
        if (n3 - n < 12) {
            return;
        }
        int n4 = (0xFF & byArray[n]) << 24 | (0xFF & byArray[n + 1]) << 16 | (0xFF & byArray[n + 2]) << 8 | 0xFF & byArray[n + 3];
        int n5 = (0xFF & byArray[n + 4]) << 8 | 0xFF & byArray[n + 5];
        int n6 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        n += 8;
        if (n4 != -889275714 || n6 != 45 || n5 > 3) {
            return;
        }
        int n7 = (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1];
        n += 2;
        --n7;
        while (n7 > 0) {
            if (n3 - n < 5) {
                return;
            }
            switch (byArray[n] & 0xFF) {
                case 7: 
                case 8: {
                    n += 3;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n += 5;
                    break;
                }
                case 5: 
                case 6: {
                    --n7;
                    n += 9;
                    break;
                }
                case 1: {
                    int n8 = (0xFF & byArray[++n]) << 8 | 0xFF & byArray[n + 1];
                    n += n8 + 2;
                    break;
                }
                default: {
                    return;
                }
            }
            --n7;
        }
        if (n3 - n < 2) {
            return;
        }
        int n9 = ++n;
        byArray[n9] = (byte)(byArray[n9] | 0x20);
    }

    public URL getBase() {
        return this.base;
    }

    public Class defineRealClassFromBytes(String string, byte[] byArray, int n, int n2) {
        this.setAccSuperBit(byArray, n, n2);
        Class<?> clazz = this.defineClass(string, byArray, n, n2);
        if (clazz != null) {
            this.resolveClass(clazz);
            return clazz;
        }
        return null;
    }
}

