/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sunw.hotjava.applets.HotJavaApplet;

public class MemoryBarApplet
extends HotJavaApplet
implements Runnable {
    static final Font font = new Font("Monospaced", 0, 14);
    Thread thread;
    int delay;
    Dimension d;

    public void init() {
        this.delay = this.getIntParameter("delay", 1000);
    }

    public synchronized void start() {
        this.d = this.size();
        this.thread = new Thread((Runnable)this, "MemoryBarApplet");
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread.stop();
        this.thread = null;
    }

    public synchronized void run() {
        while (this.thread == Thread.currentThread()) {
            try {
                this.repaint();
                this.wait(this.delay);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        Runtime runtime = Runtime.getRuntime();
        double d = 1.0 - (double)runtime.freeMemory() / (double)runtime.totalMemory();
        int n = (int)(d * (double)(this.d.width - 2));
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.d.width - 1, this.d.height - 1);
        graphics.setColor(Color.red);
        graphics.fillRect(1, 1, n, this.d.height - 2);
        graphics.setColor(Color.green);
        graphics.fillRect(n, 1, this.d.width - (n + 2), this.d.height - 2);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = String.valueOf((int)(d * 100.0)) + "%";
        n = d < 0.5 ? (n += 2) : (n -= 2 + fontMetrics.stringWidth(string));
        graphics.drawString(string, n, (this.d.height + fontMetrics.getAscent()) / 2);
    }
}

