/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import sun.misc.MessageUtils;
import sunw.hotjava.applets.HotJavaApplet;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.RaisedPanel;

public class ThreadCountApplet
extends HotJavaApplet
implements Runnable {
    HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    static final String propName = "threadlist";
    static final MessageUtils mu = new MessageUtils();
    Thread myThread;
    boolean dieNow;
    Panel count;
    Label threadCountLabel;
    ThreadGroup rootThreadGroup;
    static final int defaultMsecSleep = 2000;

    public void init() {
        this.setLayout(new BorderLayout());
        this.properties.getFont("threadlist.listfont");
        this.count = new RaisedPanel();
        this.count.setLayout(new BorderLayout());
        this.add("Center", this.count);
        this.threadCountLabel = new Label("", 0);
        this.count.add("Center", this.threadCountLabel);
        this.rootThreadGroup = this.getRootThreadGroup();
    }

    public void start() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.die();
            try {
                this.myThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.die();
        }
        this.myThread = null;
    }

    ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    void die() {
        this.dieNow = true;
    }

    void updateLabel(int n, int n2) {
        String string = "threadlist.threadcount." + (n == 1 ? "single" : "plural");
        String string2 = this.properties.getPropertyReplace(string, String.valueOf(n));
        string = "threadlist.groupcount." + (n2 == 1 ? "single" : "plural");
        String string3 = this.properties.getPropertyReplace(string, String.valueOf(n2));
        this.threadCountLabel.setText(String.valueOf(string2) + string3);
        this.count.invalidate();
        this.count.validate();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setName("ThreadCountApplet thread");
        this.dieNow = false;
        while (!this.dieNow) {
            this.updateLabel(this.rootThreadGroup.activeCount(), this.rootThreadGroup.activeGroupCount());
            int n = this.properties.getInteger("threadlist.sleep", 2000);
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

