/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import sunw.hotjava.applet.AppletEvent;
import sunw.hotjava.applet.AppletListener;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocException;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocParser;
import sunw.hotjava.doc.DocView;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventMulticaster;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentStack;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.doc.Range;
import sunw.hotjava.forms.FormPanel;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.script.ScriptingEngineInterface;
import sunw.hotjava.tags.FramePanel;
import sunw.hotjava.tags.FrameSetPanel;

public class DocumentPanel
extends ScrollPane
implements DocPanel,
DocConstants,
DocumentEventSource,
DocView {
    static final long serialVersionUID = -8883606186690557879L;
    private static int MaxWindowSize = System.getProperty("os.name").startsWith("Windows") ? Short.MAX_VALUE : Integer.MAX_VALUE;
    private static final String GENERATEDDocBase = "doc:/lib/hotjava/";
    private static final String GENERATEDDocName = "generated___";
    private static final String GENERATEDDocPrefix = "doc:/lib/hotjava/generated___";
    protected String name;
    protected DocumentFormatterPanel panel;
    protected DocumentEventMulticaster listeners = new DocumentEventMulticaster();
    protected DocumentFormatterRef current;
    protected DocumentFormatterRef next;
    private static int nameCounter;
    protected DocFont font;
    protected int marginWidth = 20;
    protected int marginHeight = 10;
    private int oldWidth = -1;
    private int oldHeight = -1;
    private int oldHorizontalInset = -1;
    static Vector panels;
    protected int appletLoadingCount;
    private HotJavaBrowserBean containingMaster;
    private FramePanel parentPanel;
    private boolean obsolete = false;
    private PanelDocListener docListener = new PanelDocListener();
    private static int generatedID;

    public DocumentPanel() {
        super(0);
        try {
            Globals.initSystem();
        }
        catch (Exception exception) {
            System.out.println("Unable to initialize bean:  " + exception);
            exception.printStackTrace();
        }
        this.initPanel();
    }

    public DocumentPanel(DocFont docFont, int n) {
        super(n);
        Adjustable adjustable;
        this.initPanel();
        this.setSize(5, 5);
        this.font = docFont;
        int n2 = Globals.getFontMetrics(docFont).getAscent();
        Adjustable adjustable2 = this.getHAdjustable();
        if (adjustable2 != null) {
            adjustable2.setUnitIncrement(n2);
        }
        if ((adjustable = this.getVAdjustable()) != null) {
            adjustable.setUnitIncrement(n2);
        }
    }

    public DocumentPanel(DocFont docFont, int n, FramePanel framePanel) {
        this(docFont, n);
        this.parentPanel = framePanel;
    }

    private void initPanel() {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        this.panel = new DocumentFormatterPanel();
        this.add(this.panel);
        this.panel.setDocumentPanel(this);
        this.setBackground(hJBProperties.getColor("html.background", null));
        panels.addElement(this);
        this.setName("XXUntitledFrame" + nameCounter);
        ++nameCounter;
        1 var2_2 = new 1();
        this.addKeyListener(var2_2);
    }

    public DocumentFormatterPanel getDocumentFormatterPanel() {
        return this.panel;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public void dispatchDocumentEvent(int n, Object object) {
        DocumentEvent documentEvent = new DocumentEvent(this, n, object);
        this.listeners.documentChanged(documentEvent);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        if (string != null) {
            string = string.toLowerCase();
        }
        this.name = string;
        if (string2 != null) {
            this.dispatchDocumentEvent(1030, string2);
        }
        this.dispatchDocumentEvent(1029, string);
    }

    public Document getDocument() {
        if (this.current != null) {
            return this.current.getDocument();
        }
        return null;
    }

    public void gotoLabel(String string) {
        if (this.current != null) {
            this.current.getFormatter().gotoLabel(string);
        }
    }

    public DocFont getDocFont() {
        return this.font;
    }

    public void setMargins(int n, int n2) {
        if (this.marginWidth != n || this.marginHeight != n2) {
            this.marginWidth = n;
            this.marginHeight = n2;
            if (this.current != null) {
                this.current.getFormatter().setMargins(n, n2);
            }
        }
    }

    public void reloadDocument() {
        Document document = this.getDocument();
        if (document != null && document.getURL() != null) {
            try {
                this.current.getFormatter().reset();
                this.current.getFormatter().clearParentBackground();
                this.current.getFormatter().top();
                document.reload();
                if (document.isOkToFormat()) {
                    this.current.getFormatter().forceFormatScreen();
                } else {
                    document.addView(this);
                }
                String string = document.getURL().getRef();
                if (string != null) {
                    this.gotoLabel(string);
                    return;
                }
            }
            catch (DocException docException) {
                docException.printStackTrace();
                return;
            }
        }
    }

    void forceRelayout() {
        Document document = this.getDocument();
        if (document != null && document.getURL() != null) {
            int n = this.getComponentCount() - 1;
            while (n >= 0) {
                if (this.getComponent(n) instanceof DocumentFormatterPanel) {
                    Container container = (Container)this.getComponent(n);
                    Component[] componentArray = container.getComponents();
                    int n2 = container.getComponentCount() - 1;
                    while (n2 >= 0) {
                        if (componentArray[n2] instanceof FormPanel) {
                            ((FormPanel)componentArray[n2]).forceResize();
                        }
                        --n2;
                    }
                }
                --n;
            }
            this.current.getFormatter().reset();
            this.current.getFormatter().layout();
            this.validate();
        }
    }

    public boolean showsSameDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null && document2.getURL() != null && document != null && document2.getURL().equals(document.getURL()) && !document2.hasJavaScriptTags()) {
            String string = document.getURL().getRef();
            if (string != null) {
                this.gotoLabel(string);
            }
            if (document2.getClientPullSpec() != null || document2.isExpired()) {
                return false;
            }
            return document.getConnector() == null;
        }
        return false;
    }

    public boolean hasFrameSetPanel(DocumentFormatter documentFormatter) {
        return documentFormatter.hasFrameSetPanel();
    }

    public void reload() {
        if (this.current == null) {
            return;
        }
        URL uRL = this.current.getURL();
        if (uRL != null && uRL.toExternalForm().startsWith(GENERATEDDocPrefix)) {
            return;
        }
        this.reloadDocument();
    }

    public void activateItemComponents() {
        if (this.current != null) {
            this.current.getFormatter().activateItemComponents();
        }
    }

    public void activateSubItems() {
        if (this.current != null) {
            this.current.getFormatter().activateSubItems();
        }
    }

    public void start() {
        if (this.current != null) {
            this.current.getFormatter().initializeParent();
            this.current.getFormatter().start();
        }
    }

    public void stop() {
        if (this.current != null) {
            this.current.getFormatter().stop();
        }
    }

    public void interruptLoading() {
        if (this.current != null) {
            this.current.getFormatter().interruptLoading();
        }
    }

    public void removeNotify() {
        this.stop();
        this.destroy();
        super.removeNotify();
    }

    public void destroy() {
        String string = this.getName();
        this.dispatchDocumentEvent(1030, string);
        this.setFormatter(null);
        if (this.containingMaster != null) {
            this.containingMaster.removeTopDocListenerFromSource(this);
        }
        if (this.docListener != null) {
            this.removeDocumentListener(this.docListener);
            this.docListener = null;
        }
        panels.removeElement(this);
    }

    public void notify(Document document, int n, int n2, int n3) {
        if (n == 23) {
            this.showNextFormatter();
            this.next = null;
            document.removeView(this);
            this.current.getFormatter().forceFormatScreen();
        }
    }

    public void reformat() {
    }

    public int findYFor(int n) {
        return 0;
    }

    public void print(PrintJob printJob, HotJavaBrowserBean hotJavaBrowserBean) throws DocBusyException {
        DocumentFormatter documentFormatter = this.current.getFormatter();
        if (documentFormatter.hasFrameSetPanel()) {
            int n = documentFormatter.countPanels();
            int n2 = 0;
            while (n2 < n) {
                Component component = documentFormatter.getPanel(n2);
                if (component instanceof FrameSetPanel) {
                    ((FrameSetPanel)component).print(printJob, hotJavaBrowserBean);
                }
                ++n2;
            }
            return;
        }
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        int n = hJBProperties.getInteger("hotjava.printfontsize", 0);
        DocFont docFont = DocFont.findFont(true, 0, 5 + n);
        new DocumentFormatter(this.current.getFormatter(), docFont).print(printJob, hotJavaBrowserBean);
    }

    public boolean find(String string) {
        return this.find(string, true);
    }

    public boolean find(String string, boolean bl) {
        return this.find(string, bl, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean find(String string, boolean bl, boolean bl2) {
        Document document = this.getDocument();
        Range range = null;
        DocumentFormatter documentFormatter = this.current.getFormatter();
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document2 = document;
            synchronized (document2) {
                int n = documentFormatter.ds.selEnd;
                if (n < 0) {
                    range = document.find(string, 0, bl);
                } else {
                    range = document.find(string, n, bl);
                    if (range == null) {
                        range = document.find(string, 0, bl);
                    }
                }
                if (range == null) {
                    return false;
                }
                try {
                    int n2 = documentFormatter.findYFor(range.minVal);
                    int n3 = documentFormatter.getDocumentY();
                    if (n2 < n3 || n2 > n3 + documentFormatter.height) {
                        documentFormatter.scrollTo(0, n2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                documentFormatter.showSelection(false);
                documentFormatter.select(range.minVal, range.maxVal);
                documentFormatter.showSelection(true);
                return true;
            }
        }
    }

    int getVerticalInset(boolean bl) {
        Insets insets = this.insets();
        int n = this.getHScrollbarHeight();
        int n2 = insets.top + insets.bottom;
        if (bl && n2 > n) {
            n2 -= n;
        }
        return n2;
    }

    int getHorizontalInset(boolean bl) {
        Insets insets = this.insets();
        int n = this.getVScrollbarWidth();
        int n2 = insets.left + insets.right;
        if (bl && n2 >= n) {
            n2 -= n;
        }
        return n2;
    }

    private void setFormatterSize(Dimension dimension, DocumentFormatter documentFormatter) {
        int n = dimension.width;
        int n2 = dimension.height;
        if (documentFormatter.hasFrameSetPanel()) {
            int n3 = this.getHorizontalInset(true);
            int n4 = this.getVerticalInset(true);
            documentFormatter.setSize(n - n3, n2 - n4, 0, true);
            return;
        }
        int n5 = this.getHorizontalInset(false);
        int n6 = this.getVerticalInset(true);
        int n7 = n5 - this.getHorizontalInset(true);
        documentFormatter.setSize(n -= n5, n2 -= n6, n7);
    }

    protected void fitPanelToDocument() {
        DocumentFormatter documentFormatter = this.current.getFormatter();
        Dimension dimension = this.getSize();
        int n = this.getVScrollbarWidth();
        int n2 = this.getHScrollbarHeight();
        Insets insets = this.getInsets();
        boolean bl = insets.left + insets.right >= n;
        boolean bl2 = insets.top + insets.bottom >= n2;
        int n3 = dimension.width - (insets.left + insets.right) - (bl ? n : 0);
        int n4 = dimension.height - (insets.top + insets.bottom) - (bl2 ? n2 : 0);
        int n5 = this.panel.getSize().width;
        int n6 = this.panel.getSize().height;
        int n7 = documentFormatter.docWidth;
        int n8 = documentFormatter.docHeight;
        int n9 = n5;
        int n10 = n6;
        if (n7 <= n3) {
            n9 = n8 > n4 ? n3 - n : n3;
        }
        if (n8 <= n4) {
            n10 = n7 > n3 ? n4 - n2 : n4;
        }
        if (n7 > n3) {
            n9 = n7;
        }
        if (n8 > n4) {
            n10 = n8;
        }
        if (n9 > MaxWindowSize) {
            n9 = MaxWindowSize;
        }
        if (n10 > MaxWindowSize) {
            n10 = MaxWindowSize;
        }
        if (n9 != n5 || n10 != n6) {
            Document document = this.getDocument();
            if (document != null) {
                Object object = Globals.getAwtLock();
                synchronized (object) {
                    Document document2 = document;
                    synchronized (document2) {
                        this.panel.setSize(n9, n10);
                        this.validate();
                    }
                    return;
                }
            }
            this.panel.setSize(n9, n10);
            this.validate();
        }
    }

    private void showNextFormatter() {
        if (this.next != null) {
            this.showIt(this.next);
        }
    }

    private void setFormatter(DocumentFormatterRef documentFormatterRef) {
        DocumentFormatter documentFormatter;
        if (this.current != null && this.current != documentFormatterRef) {
            documentFormatter = this.getFormatter();
            this.dispatchDocumentEvent(1018, documentFormatter);
            documentFormatter.getDocument().removeDocumentListener(this.docListener);
            documentFormatter.removeDocumentListener(this.docListener);
            documentFormatter.removeListeners();
            this.deregisterInterestIn(documentFormatter.getDocument());
            this.current.getFormatter().setObsolete(true);
            this.current.removeClient();
        }
        if (this.current != documentFormatterRef) {
            this.current = documentFormatterRef;
        }
        if (documentFormatterRef == null) {
            return;
        }
        documentFormatter = this.current.getFormatter();
        if (documentFormatterRef.offsetStored) {
            documentFormatterRef.offsetStored = false;
        } else if (documentFormatter.getDocument().getURL() != null && documentFormatter.getDocument().getURL().getRef() != null) {
            documentFormatter.gotoLabel(documentFormatter.getDocument().getURL().getRef());
        } else {
            documentFormatter.scrollTo(0, 0);
        }
        this.dispatchDocumentEvent(1017, documentFormatter);
        Container container = this.getParent();
        if (!documentFormatter.hasFrameSetPanel()) {
            if (!(container instanceof FramePanel)) {
                this.dispatchDocumentEvent(1041, null);
                return;
            }
            this.dispatchDocumentEvent(1041, container);
            ((FramePanel)container).setSelected(true);
        }
    }

    protected void registerInterestIn(Document document) {
    }

    protected void deregisterInterestIn(Document document) {
    }

    public DocumentFormatter getFormatter() {
        if (this.current == null) {
            return null;
        }
        return this.current.getFormatter();
    }

    public DocumentFormatterRef getFormatterRef() {
        return this.current;
    }

    protected Frame getContainingFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public DocumentPanel getContainingDocumentPanel() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof DocumentPanel) {
                return (DocumentPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected HotJavaBrowserBean getContainingHotJavaBrowserBean() {
        return HotJavaBrowserBean.getContainingHotJavaBrowserBean(this);
    }

    public void show(Document document) {
        this.show(new DocumentFormatterRef(this.panel, document, this.font));
    }

    public void show(DocumentFormatterRef documentFormatterRef) {
        Document document = documentFormatterRef.getDocument();
        DocumentFormatter documentFormatter = documentFormatterRef.getFormatter();
        documentFormatter.setObsolete(false);
        documentFormatter.initializeParent();
        Container container = this.getParent();
        if (container != null && container instanceof FramePanel) {
            documentFormatter.setMargins(this.marginWidth, this.marginHeight);
        }
        documentFormatter.start();
        documentFormatterRef.addClient();
        documentFormatter.addDocumentListener(this.docListener);
        documentFormatter.getDocument().addDocumentListener(this.docListener);
        documentFormatter.addListeners();
        this.registerInterestIn(documentFormatter.getDocument());
        documentFormatter.processDocumentEvent(new DocumentEvent(this, 1043, null));
        if (document.isOkToFormat()) {
            this.showIt(documentFormatterRef);
            documentFormatter.setToFormattedSize(this.panel);
            documentFormatter.dispatchDocumentEvent(1028, documentFormatter);
            return;
        }
        if (this.next != null) {
            this.next.getFormatter().stop();
        }
        document.addView(this);
        if (this.current != null) {
            this.current.getFormatter().unregisterListeners();
        }
        this.next = documentFormatterRef;
        if (this.current == null) {
            this.current = documentFormatterRef;
        }
        this.dispatchDocumentEvent(1006, documentFormatterRef.getDocument());
    }

    public void showIt(DocumentFormatterRef documentFormatterRef) {
        Document document;
        if (!documentFormatterRef.equals(this.current)) {
            this.stop();
        }
        this.setFormatter(documentFormatterRef);
        DocumentFormatter documentFormatter = documentFormatterRef.getFormatter();
        this.setMargins(this.marginWidth, this.marginHeight);
        this.setFormatterSize(this.getSize(), documentFormatter);
        if (this.current != null && (document = this.current.getDocument()).getClientPullSpec() != null) {
            this.requestTimedRefresh(document.getClientPullSpec());
        }
        if (documentFormatter.isFormatDone()) {
            this.fitPanelToDocument();
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.dispatchDocumentEvent(1006, this.getDocument());
    }

    public boolean isLoadingNext() {
        return this.next != null;
    }

    public void doLayout() {
        super.doLayout();
        Dimension dimension = this.getSize();
        int n = this.getHorizontalInset(false);
        if (this.oldWidth != dimension.width || this.oldHeight != dimension.height || this.oldHorizontalInset != n) {
            this.oldWidth = dimension.width;
            this.oldHeight = dimension.height;
            this.oldHorizontalInset = n;
            if (this.current != null) {
                DocumentFormatter documentFormatter = this.current.getFormatter();
                this.setFormatterSize(dimension, documentFormatter);
            }
        }
    }

    protected void requestTimedRefresh(String string) {
        if (this.current != null && this.current.getDocument() != null) {
            this.dispatchDocumentEvent(1002, new NamedLink("_refresh " + string, this.current.getDocument().getURL()));
        }
    }

    public void processPanelDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1012: {
                this.interruptLoading();
                return;
            }
            case 1003: {
                Object object = documentEvent.getArgument();
                DocumentFormatter documentFormatter = this.getFormatter();
                if (documentFormatter != null && documentFormatter.isFormatDone()) {
                    this.fitPanelToDocument();
                    return;
                }
                if (object == null || !(object instanceof DocumentFormatter)) break;
                this.fitPanelToDocument();
                return;
            }
            case 1004: {
                if (!(this instanceof HotJavaBrowserBean)) break;
                this.listeners.documentChanged(documentEvent);
                return;
            }
        }
    }

    protected boolean setsBaseURL() {
        return false;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey()) {
            this.processKeyActionEvent(keyEvent);
        } else {
            this.processPanelKeyEvent(keyEvent);
        }
        Container container = this.getParent();
        if (container != null) {
            container.dispatchEvent(keyEvent);
        }
    }

    protected void processPanelKeyEvent(KeyEvent keyEvent) {
    }

    public void processKeyActionEvent(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        DocumentFormatter documentFormatter = this.getFormatter();
        switch (keyEvent.getKeyCode()) {
            case 36: {
                if (object instanceof TextComponent) break;
                documentFormatter.top();
                return;
            }
            case 34: {
                documentFormatter.scrollBy(0, documentFormatter.height);
                return;
            }
            case 33: {
                documentFormatter.scrollBy(0, -documentFormatter.height);
                return;
            }
            case 35: {
                if (object instanceof TextComponent) break;
                documentFormatter.scrollTo(0, documentFormatter.docHeight - documentFormatter.height);
                return;
            }
            case 38: {
                if (object instanceof TextArea) break;
                Adjustable adjustable = this.getVAdjustable();
                documentFormatter.scrollBy(0, -adjustable.getUnitIncrement());
                return;
            }
            case 40: {
                if (object instanceof TextArea) break;
                Adjustable adjustable = this.getVAdjustable();
                documentFormatter.scrollBy(0, adjustable.getUnitIncrement());
                return;
            }
            case 37: {
                if (object instanceof TextComponent || keyEvent.getModifiers() != 0) break;
                Adjustable adjustable = this.getHAdjustable();
                documentFormatter.scrollBy(-adjustable.getUnitIncrement(), 0);
                return;
            }
            case 39: {
                if (object instanceof TextComponent || keyEvent.getModifiers() != 0) break;
                Adjustable adjustable = this.getHAdjustable();
                documentFormatter.scrollBy(adjustable.getUnitIncrement(), 0);
                return;
            }
        }
    }

    public void removePanel(DocumentPanel documentPanel) {
        panels.removeElement(documentPanel);
    }

    public void addNotify() {
        super.addNotify();
        this.containingMaster = HotJavaBrowserBean.getContainingHotJavaBrowserBean(this);
        this.containingMaster.addTopDocListenerToSource(this);
    }

    public boolean isInFrame() {
        return this.parentPanel != null;
    }

    public FramePanel getParentFramePanel() {
        return this.parentPanel;
    }

    public void setDocumentSource(Reader reader) {
        this.setDocumentSource(reader, "text/html", false, null);
    }

    public void setDocumentSource(Reader reader, String string, boolean bl, String string2) {
        Document document = this.makeNewGeneratedDocument(string2);
        try {
            new DocParser(document, reader);
            DocumentStack documentStack = this.getContainingHotJavaBrowserBean().getDocumentStack();
            DocumentFormatterRef documentFormatterRef = new DocumentFormatterRef(this.getDocumentFormatterPanel(), document, this.getDocFont());
            if (bl) {
                documentStack.replace(this, documentFormatterRef);
                return;
            }
            this.show(documentFormatterRef);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    protected Document makeNewGeneratedDocument(String string) {
        Object object;
        URL uRL = null;
        URL uRL2 = null;
        ScriptingEngineInterface scriptingEngineInterface = Globals.getScriptingEngine();
        if (scriptingEngineInterface != null) {
            uRL2 = scriptingEngineInterface.getCodebaseFromCaller();
        }
        try {
            URL uRL3;
            int n;
            if (uRL2 == null) {
                uRL2 = new URL(GENERATEDDocBase);
            }
            if ((n = ((String)(object = GENERATEDDocName + generatedID + uRL2.getFile())).lastIndexOf(47)) != -1) {
                object = ((String)object).substring(n + 1);
            }
            if (string == null) {
                int n2 = generatedID++;
                uRL3 = new URL(uRL2, GENERATEDDocName + n2 + (String)object);
            } else {
                int n3 = generatedID++;
                uRL3 = new URL(uRL2, GENERATEDDocName + n3 + (String)object + string);
            }
            uRL = uRL3;
            uRL2 = new URL(uRL2, "");
        }
        catch (MalformedURLException malformedURLException) {}
        object = new Document();
        try {
            ((Document)object).setProperty("base", uRL2);
            ((Document)object).setProperty("url", uRL);
            ((Document)object).setProperty("documentURL", "");
            ((Document)object).setProperty("documentString", "");
        }
        catch (DocException docException) {}
        return object;
    }

    public void setObsolete(boolean bl) {
        this.obsolete = bl;
    }

    public boolean getObsolete() {
        return this.obsolete;
    }

    static {
        panels = new Vector();
    }

    protected class PanelDocListener
    implements DocumentListener,
    Serializable {
        public void documentChanged(DocumentEvent documentEvent) {
            if (DocumentPanel.this.current != null) {
                DocumentPanel.this.processPanelDocumentEvent(documentEvent);
            }
        }

        protected PanelDocListener() {
            DocumentPanel.this = DocumentPanel.this;
        }
    }

    private final class AppletEventListener
    implements AppletListener {
        public void appletStateChanged(AppletEvent appletEvent) {
            switch (appletEvent.getID()) {
                case 51235: {
                    ++DocumentPanel.this.appletLoadingCount;
                    return;
                }
                case 51236: {
                    --DocumentPanel.this.appletLoadingCount;
                    return;
                }
            }
        }

        AppletEventListener() {
            DocumentPanel.this = DocumentPanel.this;
        }
    }

    private final class 1
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            DocumentPanel.this.processKeyEvent(keyEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

