/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import sunw.hotjava.misc.HJBProperties;

public class UIHJButton
extends Canvas {
    public static Color OUTLINE = new Color(102, 102, 102);
    public static Color HIGHLIGHT = Color.white;
    public static Color OVERLAP = new Color(204, 204, 204);
    public static Color FOCUS = new Color(102, 102, 153);
    private static final int DEFAULT = 0;
    private static final int DEFAULT_FP = 1;
    private static final int DEFAULT_F = 2;
    private static final int NORMAL = 3;
    private static final int NORMAL_FP = 4;
    private static final int NORMAL_F = 5;
    private String baseName;
    private Image[] buttons;
    private boolean isPressed;
    private boolean wasPressed;
    private boolean hasFocus = false;
    private boolean isDefault;
    private static final int vMargin = 10;
    private static final int hMargin = 23;
    private Dimension btnSize;
    private HJBProperties props;
    private ActionListener listeners;
    private String label;
    private String action;
    private Font font;
    private Dimension labelSize;

    public UIHJButton(String string, boolean bl, HJBProperties hJBProperties) {
        this.props = hJBProperties;
        this.setName(string);
        this.isDefault = bl;
        this.baseName = UIHJButton.getBaseName(this.getName());
        this.action = hJBProperties.getProperty("button." + string + ".action");
        if (this.action == null) {
            this.action = hJBProperties.getProperty("button." + string + ".text");
        }
        this.addMouseListener(new HJButtonMouseListener());
        this.addFocusListener(new HJButtonFocusListener());
        this.addKeyListener(new HJButtonKeyListener());
        this.font = UIHJButton.getButtonFont(hJBProperties, this.baseName);
        Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.labelSize = null;
        this.labelSize = this.getLabelSize();
        this.btnSize = new Dimension(this.labelSize.width + 23, this.labelSize.height + 10);
        this.setSize(this.btnSize);
        this.buttons = new Image[6];
        this.setFont(this.font);
        this.setBackground(new Color(0xD4D4D4));
    }

    public UIHJButton(String string, HJBProperties hJBProperties) {
        this(string, false, hJBProperties);
    }

    private static String getBaseName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private static Font getButtonFont(HJBProperties hJBProperties, String string) {
        String string2 = hJBProperties.getProperty("button." + string + ".font");
        if (string2 != null) {
            return Font.decode(string2);
        }
        return Font.decode("hotjava.font");
    }

    public String getActionCommand() {
        return this.action;
    }

    public void setActionCommand(String string) {
        this.action = string;
    }

    private String getLabel(String string) {
        String string2 = null;
        if (this.label == null) {
            string2 = "button." + string + ".text";
            this.label = this.props.getProperty(string2);
        }
        if (this.label != null) {
            return this.label;
        }
        return string2;
    }

    public Dimension getLabelSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension();
            Font font = null;
            font = UIHJButton.getButtonFont(this.props, this.baseName);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.labelSize.width = fontMetrics.stringWidth(this.props.getProperty("button." + this.getName() + ".text", "button." + this.getName() + ".text"));
            this.labelSize.height = fontMetrics.getHeight();
        }
        return this.labelSize;
    }

    public void setLabelSize(int n, int n2) {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(n, n2);
        } else {
            this.labelSize.width = n;
            this.labelSize.height = n2;
        }
        this.btnSize.width = n + 23;
        this.btnSize.height = n2 + 10;
        this.setSize(this.btnSize);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.isPressed = true;
                this.wasPressed = true;
                this.requestFocus();
                this.repaintImage();
                return;
            }
            case 502: {
                this.wasPressed = false;
                if (this.isPressed) {
                    this.isPressed = false;
                    try {
                        this.dispatchActionEvent(mouseEvent, this.action);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.repaintImage();
                return;
            }
            case 505: {
                if (this.wasPressed) {
                    this.wasPressed = false;
                    this.isPressed = false;
                }
                this.repaintImage();
                return;
            }
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefaultButton(boolean bl) {
        this.isDefault = bl;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            ActionEvent actionEvent = new ActionEvent(this, 0, this.action);
            if (this.listeners != null) {
                this.listeners.actionPerformed(actionEvent);
            }
            return;
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                this.hasFocus = true;
                this.repaintImage();
                return;
            }
            case 1005: {
                this.hasFocus = false;
                this.repaintImage();
                return;
            }
        }
    }

    protected void repaintImage() {
        this.getImage();
        this.repaint();
    }

    public Image createButtonImage(int n) {
        Serializable serializable;
        float[] fArray;
        Image image = null;
        Dimension dimension = this.getSize();
        Container container = this.getParent();
        if (container != null) {
            Color color = container.getBackground();
            fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            serializable = new Color(fArray[2], fArray[2], fArray[2]);
            this.setBackground((Color)serializable);
        }
        if ((image = this.createImage(dimension.width, dimension.height)) != null) {
            Graphics graphics = image.getGraphics();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
                if (this.isDefault) {
                    graphics.setColor(HIGHLIGHT);
                    graphics.drawRect(2, 2, dimension.width - 3, dimension.height - 3);
                    graphics.setColor(OUTLINE);
                    graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
                    graphics.drawRect(1, 1, dimension.width - 4, dimension.height - 4);
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(2, dimension.height - 3, 2, dimension.height - 3);
                    graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, 2);
                    if (n != 0) {
                        if (n == 1) {
                            graphics.setColor(Color.gray);
                            graphics.fillRect(2, 2, dimension.width - 5, dimension.height - 5);
                            graphics.drawLine(2, dimension.height - 3, 2, dimension.height - 3);
                            graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, 2);
                        }
                        graphics.setColor(FOCUS);
                        graphics.drawRect(6, 3, dimension.width - 14, dimension.height - 8);
                    }
                } else {
                    graphics.setColor(OUTLINE);
                    graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
                    graphics.setColor(HIGHLIGHT);
                    graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(1, dimension.height - 2, 1, dimension.height - 2);
                    graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, 1);
                    if (n != 3) {
                        if (n == 4) {
                            graphics.setColor(Color.gray);
                            graphics.fillRect(1, 1, dimension.width - 3, dimension.height - 3);
                            graphics.drawLine(1, dimension.height - 2, 1, dimension.height - 2);
                            graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, 1);
                        }
                        graphics.setColor(FOCUS);
                        graphics.drawRect(6, 3, dimension.width - 14, dimension.height - 8);
                    }
                }
                serializable = graphics.getFontMetrics();
                int n2 = (dimension.width - ((FontMetrics)serializable).stringWidth(this.getLabel(this.getName()))) / 2;
                int n3 = dimension.height - ((FontMetrics)serializable).getDescent() - 5;
                graphics.setColor(Color.black);
                graphics.drawString(this.getLabel(this.getName()), n2, n3);
            }
            finally {
                fArray = null;
                graphics.dispose();
            }
        }
        return image;
    }

    public Image getImage() {
        Image image;
        if (this.isDefault) {
            if (this.buttons[0] == null) {
                this.buttons[0] = this.createButtonImage(0);
            }
            image = this.buttons[0];
            if (this.hasFocus) {
                if (this.buttons[2] == null) {
                    this.buttons[2] = this.createButtonImage(2);
                }
                image = this.buttons[2];
            }
            if (this.isPressed) {
                if (this.buttons[1] == null) {
                    this.buttons[1] = this.createButtonImage(1);
                }
                image = this.buttons[1];
            }
        } else {
            if (this.buttons[3] == null) {
                this.buttons[3] = this.createButtonImage(3);
            }
            image = this.buttons[3];
            if (this.hasFocus) {
                if (this.buttons[5] == null) {
                    this.buttons[5] = this.createButtonImage(5);
                }
                image = this.buttons[5];
            }
            if (this.isPressed) {
                if (this.buttons[4] == null) {
                    this.buttons[4] = this.createButtonImage(4);
                }
                image = this.buttons[4];
            }
        }
        return image;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Image image = this.getImage();
        graphics.drawImage(image, 0, 0, this.getBackground(), this);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, actionListener);
    }

    protected void dispatchActionEvent(MouseEvent mouseEvent, String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string, mouseEvent.getModifiers());
        if (this.listeners != null) {
            this.listeners.actionPerformed(actionEvent);
        }
    }

    public Dimension getPreferredSize() {
        return this.btnSize;
    }

    public Dimension getMaximumSize() {
        return this.btnSize;
    }

    public Dimension getMinimumSize() {
        return this.btnSize;
    }

    public Dimension getSize() {
        return this.btnSize;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private final class HJButtonMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            UIHJButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            UIHJButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            UIHJButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            UIHJButton.this.processMouseEvent(mouseEvent);
        }

        HJButtonMouseListener() {
            UIHJButton.this = UIHJButton.this;
        }
    }

    private final class HJButtonFocusListener
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            UIHJButton.this.processFocusEvent(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            UIHJButton.this.processFocusEvent(focusEvent);
        }

        HJButtonFocusListener() {
            UIHJButton.this = UIHJButton.this;
        }
    }

    private final class HJButtonKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            UIHJButton.this.processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            UIHJButton.this.processKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            UIHJButton.this.processKeyEvent(keyEvent);
        }

        HJButtonKeyListener() {
            UIHJButton.this = UIHJButton.this;
        }
    }
}

