/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.TimedMessageContainer;
import sunw.hotjava.ui.UpdateableComponent;

public class UserImageButton
extends Canvas
implements UpdateableComponent {
    private boolean depressed;
    private boolean wasDepressed;
    private boolean entered;
    private Image active;
    private Image dis;
    private Image over;
    private Image old;
    private String action;
    private boolean enabled = true;
    private ActionListener listeners;
    private static Font font;
    private static int maxSize;
    private static FontMetrics fm;
    private static final int NUM_IMGS = 5;
    private Image[] btnImgs = new Image[5];
    public static Color OUTLINE;
    public static Color HIGHLIGHT;
    public static Color OVERLAP;
    private String label;
    MediaTracker tracker;
    private boolean imagesLoaded = false;
    private boolean labelInitialized = false;
    protected HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private Dimension labelSize = new Dimension();
    private static Dimension maxLabelSize;
    private static Dimension maxImageSize;
    private Dimension imageSize = new Dimension();
    private static int style;
    private static final int TEXTIMAGE = 1;
    private static final int IMAGEONLY = 2;
    private static final int TEXTONLY = 3;
    private static final int vMargin = 8;
    private static final int hMargin = 8;

    public UserImageButton(String string) {
        this.setName(string);
        if (style == 0) {
            String string2 = this.properties.getProperty("hotjava.buttonappearance", "ImageAndText");
            style = this.propToBtnType(string2);
        }
        if (style == 1 || style == 3) {
            this.labelSize = this.getLabel();
            if (UserImageButton.maxLabelSize.width < this.labelSize.width) {
                UserImageButton.maxLabelSize.width = this.labelSize.width;
            }
        }
        this.imageSize = this.loadImages();
        if (style == 1 || style == 2) {
            if (UserImageButton.maxImageSize.width < this.imageSize.width) {
                UserImageButton.maxImageSize.width = this.imageSize.width;
            }
            if (UserImageButton.maxImageSize.height < this.imageSize.height) {
                UserImageButton.maxImageSize.height = this.imageSize.height;
            }
        }
        this.action = this.properties.getProperty("button." + string + ".action", string);
        int n = (UserImageButton.maxLabelSize.width > this.imageSize.width ? UserImageButton.maxLabelSize.width : this.imageSize.width) + 8;
        int n2 = this.imageSize.height + this.labelSize.height + 8;
        this.setSize(n, n2);
        Color color = this.properties.getColor(String.valueOf(string) + ".background", null);
        if (color != null) {
            this.setBackground(color);
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new UserImageButtonMouseListener());
        this.addMouseMotionListener(new UserImageButtonMouseListener());
        1 var5_6 = new 1();
        this.addFocusListener(var5_6);
    }

    private int propToBtnType(String string) {
        if (string.equals("TextOnly")) {
            return 3;
        }
        if (string.equals("ImageOnly")) {
            return 2;
        }
        return 1;
    }

    public void updateAppearance() {
        String string = this.properties.getProperty("hotjava.buttonappearance", "ImageAndText");
        style = this.propToBtnType(string);
        if (style == 3 || style == 1) {
            this.labelSize = this.getLabel();
            if (UserImageButton.maxLabelSize.width < this.labelSize.width) {
                UserImageButton.maxLabelSize.width = this.labelSize.width;
            }
        }
        if (style == 2 || style == 1) {
            this.imageSize = this.loadImages();
            if (UserImageButton.maxImageSize.width < this.imageSize.width) {
                UserImageButton.maxImageSize.width = this.imageSize.width;
            }
            if (UserImageButton.maxImageSize.height < this.imageSize.height) {
                UserImageButton.maxImageSize.height = this.imageSize.height;
            }
        }
        int n = 0;
        while (n < 5) {
            this.btnImgs[n] = null;
            ++n;
        }
    }

    private Dimension loadImages() {
        if (!this.imagesLoaded) {
            this.imagesLoaded = true;
            Dimension dimension = new Dimension();
            String string = this.getName();
            dimension.width = this.properties.getInteger("button." + string + ".width", 20);
            dimension.height = this.properties.getInteger("button." + string + ".height", 20);
            this.tracker = new MediaTracker(this);
            this.active = this.properties.getImage(this.properties.getProperty("button." + string + ".up"));
            if (this.active != null) {
                this.tracker.addImage(this.active, 1);
            }
            this.dis = this.properties.getImage(this.properties.getProperty("button." + string + ".disabled"));
            if (this.dis != null) {
                this.tracker.addImage(this.dis, 3);
            }
            this.over = this.properties.getImage(this.properties.getProperty("button." + string + ".mouseover"));
            if (this.over != null) {
                this.tracker.addImage(this.over, 4);
            }
            try {
                this.tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            return dimension;
        }
        return this.imageSize;
    }

    private Dimension getLabel() {
        if (!this.labelInitialized) {
            this.labelInitialized = true;
            Dimension dimension = new Dimension();
            if (fm == null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                font = this.properties.getFont("hotjava.buttonlabel.font", new Font("SansSerif", 0, 8));
                fm = toolkit.getFontMetrics(font);
                UserImageButton.maxLabelSize.height = fm.getHeight();
            }
            this.label = this.properties.getProperty("button." + this.getName() + ".label", "");
            dimension.width = fm.stringWidth(this.label);
            dimension.height = UserImageButton.maxLabelSize.height;
            return dimension;
        }
        return this.labelSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image createButtonImage(Image image, boolean bl) {
        Image image2 = null;
        Dimension dimension = this.getSize();
        image2 = this.createImage(dimension.width, dimension.height);
        if (image2 == null) return image2;
        Graphics graphics = image2.getGraphics();
        try {
            int n = 0;
            int n2 = 0;
            if (image != null) {
                n = image.getWidth(this);
                n2 = image.getHeight(this);
            }
            if (this.depressed) {
                graphics.setColor(Color.gray);
                graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (bl) {
                graphics.setColor(OUTLINE);
                graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
                graphics.setColor(HIGHLIGHT);
                graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
                graphics.setColor(OVERLAP);
                graphics.drawLine(1, dimension.height - 2, 1, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, 1);
            }
            graphics.setColor(Color.black);
            graphics.setFont(font);
            graphics.setColor(Color.black);
            switch (style) {
                case 1: {
                    int n3 = (dimension.width - fm.stringWidth(this.label)) / 2;
                    int n4 = dimension.height - fm.getDescent() - 4;
                    if (!this.isButtonEnabled()) {
                        graphics.setColor(Color.white);
                        graphics.drawString(this.label, n3 + 1, n4 + 1);
                        graphics.setColor(Color.gray);
                    }
                    graphics.drawString(this.label, n3, n4);
                    if (image == null) return image2;
                    graphics.drawImage(image, (dimension.width - n) / 2, (n4 - fm.getAscent() - n2) / 2, this);
                    return image2;
                }
                case 3: {
                    int n5 = (dimension.width - fm.stringWidth(this.label)) / 2;
                    int n6 = dimension.height - fm.getDescent() - 4;
                    if (!this.isButtonEnabled()) {
                        graphics.setColor(Color.white);
                        graphics.drawString(this.label, n5 + 1, n6 + 1);
                        graphics.setColor(Color.gray);
                    }
                    graphics.drawString(this.label, n5, n6);
                    return image2;
                }
                case 2: {
                    if (image == null) return image2;
                    graphics.drawImage(image, (dimension.width - n) / 2, (dimension.height - n2) / 2, this);
                    return image2;
                }
            }
            return image2;
        }
        finally {
            Object var9_12 = null;
            graphics.dispose();
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, actionListener);
    }

    protected void dispatchActionEvent(MouseEvent mouseEvent, String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string, mouseEvent.getModifiers());
        if (this.listeners != null) {
            this.listeners.actionPerformed(actionEvent);
        }
    }

    private void redispatch(MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocation();
        mouseEvent.translatePoint(point.x, point.y);
        if (this.getParent() instanceof TimedMessageContainer) {
            ((TimedMessageContainer)this.getParent()).processMouseEvent(mouseEvent);
            return;
        }
        mouseEvent.getComponent().getParent().dispatchEvent(mouseEvent);
    }

    private void redispatch(FocusEvent focusEvent) {
        focusEvent.getComponent().getParent().dispatchEvent(focusEvent);
    }

    public void processLostFocusEvent(FocusEvent focusEvent) {
        this.redispatch(focusEvent);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.isButtonEnabled()) {
                    this.depressed = true;
                    this.wasDepressed = true;
                }
                this.repaintImage();
                break;
            }
            case 502: {
                if (this.isButtonEnabled()) {
                    this.wasDepressed = false;
                    if (this.depressed) {
                        this.depressed = false;
                        try {
                            this.dispatchActionEvent(mouseEvent, this.action);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                this.repaintImage();
                break;
            }
            case 504: {
                this.entered = true;
                if (this.wasDepressed) {
                    this.depressed = true;
                }
                this.repaintImage();
                try {
                    this.dispatchActionEvent(mouseEvent, "entered " + this.action);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 505: {
                this.entered = false;
                if (this.wasDepressed) {
                    this.depressed = false;
                }
                this.repaintImage();
                try {
                    this.dispatchActionEvent(mouseEvent, "");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
        }
        this.redispatch(mouseEvent);
    }

    private void setNewSize() {
        switch (style) {
            case 1: {
                int n = (UserImageButton.maxLabelSize.width > UserImageButton.maxImageSize.width ? UserImageButton.maxLabelSize.width : UserImageButton.maxImageSize.width) + 8;
                super.setSize(n, fm.getHeight() + UserImageButton.maxImageSize.height + 8);
                return;
            }
            case 3: {
                super.setSize(UserImageButton.maxLabelSize.width + 8, UserImageButton.maxLabelSize.height + 8);
                return;
            }
            case 2: {
                super.setSize(this.imageSize.width + 8, UserImageButton.maxImageSize.height + 8);
                return;
            }
        }
    }

    public Dimension getSize() {
        this.setNewSize();
        return super.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    protected void repaintImage() {
        Image image = this.getImage();
        if (image != null && image != this.old) {
            this.old = image;
            this.prepareImage(image, this);
            this.repaint();
        }
    }

    protected Image getImage() {
        Image image;
        Image image2 = null;
        if (this.isButtonEnabled()) {
            if (this.depressed) {
                if (this.btnImgs[1] == null) {
                    this.btnImgs[1] = this.createButtonImage(this.active, false);
                }
                image = this.btnImgs[1];
            } else if (this.entered) {
                if (this.btnImgs[3] == null) {
                    image2 = this.over == null ? this.active : this.over;
                    this.btnImgs[3] = this.createButtonImage(image2, true);
                }
                image = this.btnImgs[3];
            } else {
                if (this.btnImgs[0] == null) {
                    this.btnImgs[0] = this.createButtonImage(this.active, false);
                }
                image = this.btnImgs[0];
            }
        } else {
            if (this.btnImgs[2] == null) {
                image2 = this.dis == null ? this.active : this.dis;
                this.btnImgs[2] = this.createButtonImage(image2, false);
            }
            image = this.btnImgs[2];
        }
        return image;
    }

    public void update(Graphics graphics) {
        Image image = this.getImage();
        graphics.drawImage(image, 0, 0, this.getBackground(), this);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Image image2 = this.getImage();
        if (image == image2 && (n & 0x38) != 0) {
            this.repaint((n & 0x30) == 0 ? 100 : 0);
        }
        return image == image2 && (n & 0xA0) == 0;
    }

    public void setEnabled(boolean bl) {
        if (this.isButtonEnabled() != bl) {
            this.enabled = bl;
            int n = bl ? 12 : 0;
            this.setCursor(Cursor.getPredefinedCursor(n));
            this.repaintImage();
        }
    }

    public boolean isButtonEnabled() {
        return this.enabled;
    }

    static {
        OUTLINE = new Color(102, 102, 102);
        HIGHLIGHT = Color.white;
        OVERLAP = new Color(204, 204, 204);
        maxLabelSize = new Dimension();
        maxImageSize = new Dimension();
    }

    private final class UserImageButtonMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            UserImageButton.this.processMouseEvent(mouseEvent);
        }

        UserImageButtonMouseListener() {
            UserImageButton.this = UserImageButton.this;
        }
    }

    private final class 1
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            UserImageButton.this.processLostFocusEvent(focusEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

