#include "EncoderView.h"

MediaEncoderWindow::MediaEncoderWindow(BRect frame, BView *pBView)
	: BWindow(frame, "Encoder Parameters", B_DOCUMENT_WINDOW_LOOK, B_MODAL_APP_WINDOW_FEEL,
			  B_NOT_RESIZABLE | B_NOT_ZOOMABLE | B_ASYNCHRONOUS_CONTROLS)
{
	// Create and Acquire the Semaphore
	sem=create_sem(0,"EncoderView");

	theView = pBView;
	AddChild(theView);
	ResizeTo(theView->Bounds().Width(),theView->Bounds().Height());
}

MediaEncoderWindow::~MediaEncoderWindow()
{
	// The View must continue to exist until conversion complete.
	RemoveChild(theView);
	delete_sem(sem);
}

void MediaEncoderWindow::MessageReceived(BMessage *msg)
{
}

bool MediaEncoderWindow::QuitRequested()
{
	return true;
}

void MediaEncoderWindow::Go()
{
	this->Show();
	acquire_sem(sem);	//wait until window is quit
}
